package com.framsticks.test;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.testng.annotations.*;

import com.framsticks.util.FramsticksException;
import com.framsticks.util.dispatching.Dispatcher;
import com.framsticks.util.dispatching.Dispatching;
import com.framsticks.util.dispatching.Dispatching.Waiter;
import com.framsticks.util.dispatching.ExceptionHandler;
import com.framsticks.util.dispatching.ExceptionResultHandler;

// import static org.fest.assertions.Assertions.*;

public class TestConfiguration {

	private static final Logger log = Logger.getLogger(TestConfiguration.class);

	@BeforeClass
	public void setUpConfiguration() {
		PropertyConfigurator.configure(TestConfiguration.class.getResource("/log4j.properties"));
		log.info("testing " + this.getClass());
	}

	private final List<AssertionError> asyncAssertions = new LinkedList<>();

	public static AssertionError wrapInAssertion(Throwable throwable) {
		if (throwable instanceof AssertionError) {
			return (AssertionError) throwable;
		}

		AssertionError ae = new AssertionError();
		ae.initCause(throwable);
		return ae;
	}

	public void addAsyncAssertion(Throwable throwable) {
		synchronized (asyncAssertions) {
			asyncAssertions.add(wrapInAssertion(throwable));
		}
	}

	public ExceptionHandler createExceptionHandler() {
		return new ExceptionHandler() {
			@Override
			public boolean handle(Dispatcher<?> dispatcher, Throwable throwable) {
				addAsyncAssertion(throwable);
				return true;
			}
		};
	}

	@AfterMethod
	public void waitForWaiters() {
		for (Waiter w : waiters) {
			try {
				w.waitFor();
			} catch (FramsticksException e) {
				AssertionError ae = new AssertionError();
				ae.initCause(e);
				asyncAssertions.add(ae);
			}
		}
	}

	@AfterMethod(timeOut = 1000, dependsOnMethods = "waitForWaiters")
	public void processAsyncAssertions() {
		synchronized (asyncAssertions) {
			if (asyncAssertions.isEmpty()) {
				return;
			}
			AssertionError a = asyncAssertions.get(0);
			asyncAssertions.remove(0);
			throw a;
		}
	}

	final Set<Waiter> waiters = new HashSet<>();

	@BeforeMethod
	public void clearWaiters() {
		waiters.clear();
	}

	protected Dispatching.Waiter produceWaiter(double timeOut) {
		Waiter waiter = new Waiter(timeOut, failOnException);
		waiters.add(waiter);
		return waiter;
	}

	public final ExceptionResultHandler failOnException = new ExceptionResultHandler() {
		@Override
		public void handle(FramsticksException e) {
			log.error("passing exception as assertion in " + TestConfiguration.this.getClass(), e);
			addAsyncAssertion(e);
		}
	};
}
