
package com.framsticks.gui;

import static org.fest.assertions.Assertions.assertThat;

import org.fest.swing.fixture.JPanelFixture;
import org.testng.annotations.Test;

import com.framsticks.core.Path;
import com.framsticks.core.Tree;
import com.framsticks.core.LocalTree;
import com.framsticks.params.AccessInterface;
import com.framsticks.params.EventListener;
import com.framsticks.params.FramsClass;
import com.framsticks.params.ReflectionAccess;
import com.framsticks.params.types.EventParam;
import com.framsticks.params.types.StringParam;
import com.framsticks.parsers.XmlLoader;
import com.framsticks.test.ChangeEvent;
import com.framsticks.test.TestClass;
import com.framsticks.util.dispatching.FutureHandler;
// import com.framsticks.util.dispatching.Dispatching;
import com.framsticks.util.dispatching.RunAt;
import static com.framsticks.core.TreeOperations.*;

@Test
public class ProcedureBrowserTest extends BrowserBaseTest {

	LocalTree tree;

	@Override
	protected void configureBrowser() {
		browser = new XmlLoader().load(Browser.class, getClass().getResourceAsStream("/configs/ProcedureBrowserTest.xml"));

		assertThat(browser.getTrees().size()).isEqualTo(1);
		assertThat(browser.getTrees().get("test")).isInstanceOf(LocalTree.class);

		tree = (LocalTree) browser.getTrees().get("test");
	}

	@Test(timeOut = 10000)
	public void testShow() {
		tree.dispatch(new RunAt<Tree>(failOnException) {
			@Override
			protected void runAt() {
				assertThat(tree.getRootObject()).isInstanceOf(TestClass.class);
			}
		});

		clickAndExpandPath("test");

		tree.dispatch(new RunAt<Tree>(failOnException) {
			@Override
			protected void runAt() {
				assertThat(bindAccess(tree, "/").getFramsClass().getParam("history")).isInstanceOf(StringParam.class);
			}
		});

		// monitor.useFor(4.0);

		tree.dispatch(new RunAt<Tree>(failOnException) {
			@Override
			protected void runAt() {
				AccessInterface access = bindAccess(tree, "/");
				assertThat(access).isInstanceOf(ReflectionAccess.class);
				FramsClass framsClass = access.getFramsClass();
				assertThat(framsClass.getParamCount()).isEqualTo(5);
				assertThat(framsClass.getParam(0).getId()).isEqualTo("name");
				assertThat(framsClass.getParam(1).getId()).isEqualTo("history");
				assertThat(framsClass.getParam(2).getId()).isEqualTo("history_changed");
				assertThat(framsClass.getParam(3).getId()).isEqualTo("appendHistory");
				assertThat(framsClass.getParam(4).getId()).isEqualTo("resetHistory");

				assertThat(access.get("history", String.class)).isEqualTo("initial|");
			}
		});

		// frame.panel("TestClass");
		final JPanelFixture appendHistory = frame.panel("TestClass").panel("appendHistory");
		appendHistory.panel("arg0").textBox("value").enterText("Żółw");
		assertThat(appendHistory.panel("arg0").textBox("value").text()).isEqualTo("Żółw");
		clickButton(appendHistory.button("call"));
		waitForIdle();

		final EventListener<ChangeEvent> listener = new EventListener<ChangeEvent>() {

			@Override
			public void action(ChangeEvent argument) {
				assertThat(argument.history).isEqualTo("");
			}
		};

		tree.dispatch(new RunAt<Tree>(failOnException) {
			@Override
			protected void runAt() {
				AccessInterface access = bindAccess(tree, "/");
				assertThat(access.get("history", String.class)).isEqualTo("initial|Żółw|");

				tree.addListener(Path.to(tree, "/"), access.getFramsClass().getParamEntry("history_changed", EventParam.class), listener, ChangeEvent.class, FutureHandler.doNothing(Void.class, failOnException));
			}
		});

		clickButton(frame.panel("TestClass").panel("resetHistory").button("call"));
		waitForIdle();

		tree.dispatch(new RunAt<Tree>(failOnException) {
			@Override
			protected void runAt() {
				AccessInterface access = bindAccess(tree, "/");
				assertThat(access.get("history", String.class)).isEqualTo("");

				tree.removeListener(Path.to(tree, "/"), access.getFramsClass().getParamEntry("history_changed", EventParam.class), listener, FutureHandler.doNothing(Void.class, failOnException));
			}
		});
	}
}
