package com.framsticks.gui;

import static org.fest.assertions.Assertions.assertThat;
import static org.fest.swing.edt.GuiActionRunner.execute;

import java.awt.event.KeyEvent;


import org.apache.log4j.Logger;
import org.fest.swing.edt.GuiTask;
import org.testng.annotations.Test;

import com.framsticks.model.ModelPackage;
import com.framsticks.remote.RemoteTree;
import com.framsticks.util.dispatching.Dispatching;

public class BrowserTest extends BrowserBaseTest {

	private static final Logger log = Logger.getLogger(BrowserTest.class);

	RemoteTree localhost;

	@Override
	protected void configureBrowser() {
		browser = new Browser();

		localhost = new RemoteTree();
		localhost.setName("localhost");
		localhost.setAddress("localhost:9009");
		localhost.usePackage(new ModelPackage());

		browser.addTree(localhost);

	}

	@Test(timeOut = 30000)
	public void testShow() {
		Dispatching.synchronize(localhost, 1.0);
		Dispatching.sleep(2.0);
		log.info("testing");
		clickAndExpandPath("localhost");
		// tree.clickRow(0).expandRow(0);
		// robot.waitForIdle();

		clickAndExpandPath("localhost/simulator");
		// tree.clickRow(1).expandRow(1);
		// robot.waitForIdle();
		assertThat(tree.valueAt(1)).isEqualTo("simulator");
		robot.waitForIdle();
		execute(new GuiTask() {
			@Override
			protected void executeInEDT() throws Throwable {
				assertThat(frame.panel("Simulator").component().isVisible()).isTrue();
			}
		});


		clickAndExpandPath("localhost/simulator/genepools");
		clickAndExpandPath("localhost/simulator/genepools/groups");
		clickAndExpandPath("localhost/simulator/genepools/groups/Genotypes");
		clickAndExpandPath("localhost/simulator/genepools/groups/Genotypes/genotypes");
		// Dispatching.sleep(2.0);
		// clickAndExpandPath("localhost/simulator/genepools/groups/Genotypes/genotypes");
		robot.pressAndReleaseKey(KeyEvent.VK_J);
		waitForIdle();
		Dispatching.sleep(2.0);

		frame.panel("Genotype").panel("name").textBox("value").enterText("-Żółw");
		clickButton(frame.panel("Genotype").button("apply"));

		Dispatching.sleep(1.0);
	}



}
