package com.framsticks.gui;

import javax.swing.JFrame;

import org.apache.log4j.Logger;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.fixture.FrameFixture;
import org.fest.swing.fixture.JTreeFixture;
import org.testng.annotations.Test;


import org.fest.swing.edt.GuiActionRunner;

import com.framsticks.util.dispatching.Dispatching;
import com.framsticks.util.dispatching.Joinable;

@Test
public abstract class BrowserBaseTest extends GuiTest {

	private static final Logger log = Logger.getLogger(BrowserTest.class);

	protected Browser browser;
	protected FrameFixture frame;
	protected JTreeFixture tree;

	@Override
	protected Joinable createSubject() {
		configureBrowser();
		// browser.getMainFrame().getStatusBar().setExceptionHandler(failOnException);
		return browser;
	}

	protected void setUpAfterUse() {
		frame = new FrameFixture(robot,
				GuiActionRunner.execute(new GuiQuery<JFrame>() {
					@Override
					protected JFrame executeInEDT() throws Throwable {
						return browser.getMainFrame().getSwing();
					}
				}));

		tree = frame.tree("tree");

		log.debug("frame fixture done");
	}


	protected abstract void configureBrowser();

	protected void clickAndExpandPath(String path) {
		tree.clickPath(path);
		Dispatching.sleep(2.0);
		tree.expandPath(path);
		robot.waitForIdle();
	}


}
