package com.framsticks.core;

// import static org.mutabilitydetector.unittesting.MutabilityAssert.*;
// import static org.mutabilitydetector.unittesting.MutabilityMatchers.*;
// import static org.mutabilitydetector.unittesting.AllowedReason.*;

// import java.util.LinkedList;

import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

import com.framsticks.test.TestConfiguration;
import com.framsticks.util.lang.Pair;

import static org.fest.assertions.Assertions.*;

@Test
public class PathTest extends TestConfiguration {

	@BeforeClass
	public void setUp() {
		// assertInstancesOf(Path.class,
		// 		areImmutable(),
		// 		allowingNonFinalFields(),
		// 		provided(String.class).isAlsoImmutable(),
		// 		provided(LinkedList.class).isAlsoImmutable()
		// 		);
	}

	@Test(dataProvider = "pathValidationProvider")
	public void pathValidation(String path, boolean ok) {
		assertThat(Path.isValidString(path)).describedAs(path).isEqualTo(ok);
	}

	@Test(dataProvider = "pathSplitingProvider")
	public void pathSpliting(String path, String prefix, String suffix) {
		Pair<String, String> p = Path.removeLastElement(path);
		assertThat(p.first).isEqualTo(prefix);
		assertThat(p.second).isEqualTo(suffix);
	}

	@DataProvider
	public Object[][] pathValidationProvider() {
		return new Object[][] {
			{ "/", true },
			{ "/path", true },
			{ "path", false },
			{ "/path/to/", false },
			{ "/path/to", true },
			{ "/testClass/history_changed", true },
			{ "/cli/events/e0", true }

		};
	}

	@DataProvider
	public Object[][] pathSplitingProvider() {
		return new Object[][] {
			{ "/event", "/", "event" },
			{ "/path/event", "/path", "event" }
		};
	}

}
