package com.framsticks.util.lang;

import com.framsticks.util.FramsticksException;

/**
 * @author Piotr Sniegowski
 */
public abstract class Strings {

	public static String valueOf(Object o) {
		if (o == null) {
			return null;
		}
		return o.toString();
	}

	public static boolean notEmpty(String str) {
		return str != null && !str.equals("");
	}

	public static void assureNotEmpty(String str) {
		if (!notEmpty(str)) {
			throw new FramsticksException().msg("string is empty");
		}
	}

	public static String toStringNullProof(Object object) {
		return toStringNullProof(object, "");
	}

	public static String toStringNullProof(Object object, String def) {
		if (object == null) {
			return def;
		}
		return object.toString();
	}

	public static String toStringEmptyProof(Object object, Object def) {
		if (object == null) {
			return def.toString();
		}
		String v = object.toString();
		return notEmpty(v) ? v : def.toString();
	}

	public static String collapse(String s) {
		if (s == null) {
			return null;
		}
		s = s.trim();
		return (s.equals("")) ? null : s;
	}

	public static Pair<String, String> splitIntoPair(String string, char separator, String second) {
		int pos = string.indexOf(separator);
		if (pos == -1) {
			return new Pair<String, String>(string, second);
		} else {
			return new Pair<String, String>(string.substring(0, pos), string.substring(pos + 1));
		}
	}

	public static String capitalize(String input) {
		return input.substring(0, 1).toUpperCase() + input.substring(1);
	}

	public static String uncapitalize(String input) {
		return input.substring(0, 1).toLowerCase() + input.substring(1);
	}

	public static String commonPrefix(String a, String b) {
		int length = Math.min(a.length(), b.length());
		int i = 0;
		while ((i < length) && (a.charAt(i) == b.charAt(i))) {
			++i;
		}
		return a.substring(0, i);
	}

}
