package com.framsticks.util.lang;


/**
 * @author Piotr Sniegowski
 */
public abstract class Casting {
	public static <T> T tryCast(Class<T> class_, Object object) {
		try {
			return class_.cast(object);
		} catch (ClassCastException ignored) {
			return null;
		}
	}

	public static <T> T assertCast(Class<T> class_, Object object) {
		try {
			return class_.cast(object);
		} catch (ClassCastException ignored) {
			assert false;
			return null;
		}
	}

	public static <T> T throwCast(Class<T> class_, Object object) {
		if (object == null) {
			throw new NullPointerException();
		}
		return class_.cast(object);
	}
}
