package com.framsticks.util.dispatching;

import com.framsticks.util.FramsticksException;

public abstract class FutureHandler<T> extends Future<T> {

	protected final ExceptionResultHandler handler;

	public FutureHandler(ExceptionResultHandler handler) {
		assert handler != null;
		this.handler = handler;
	}

	@Override
	public final void handle(FramsticksException exception) {
		handler.handle(exception);
	}

	public static <T> FutureHandler<T> doNothing(Class<T> type, ExceptionResultHandler handler) {
		return new FutureHandler<T>(handler) {

			@Override
			protected void result(T result) {

			}
		};
	}

}
