package com.framsticks.test;

import java.util.LinkedList;
import java.util.List;

import org.apache.log4j.Logger;

import com.framsticks.params.EventListener;
import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;
import com.framsticks.params.types.ProcedureParam;

@FramsClassAnnotation(order = {"name", "history", "history_changed", "appendHistory", "resetHistory"}, register = {ChangeEvent.class})
public class TestClass {
	private static final Logger log =
		Logger.getLogger(TestClass.class);


	protected String name = "test";
	protected String history = "initial|";
	protected final List<EventListener<ChangeEvent>> historyListeners = new LinkedList<>();

	/**
	 * @return the name
	 */
	@ParamAnnotation
	public String getName() {
		return name;
	}

	/**
	 * @param name the name to set
	 */
	@ParamAnnotation
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the history
	 */
	@ParamAnnotation
	public String getHistory() {
		return history;
	}

	/**
	 * @param history the history to set
	 */
	@ParamAnnotation
	public void setHistory(String history) {
		this.history = history;
	}

	@ParamAnnotation(paramType = ProcedureParam.class)
	public int appendHistory(String line) {
		log.debug("appending '" + line + "'");
		history = history + line + "|";
		fireHistoryChange();
		return history.length();
	}

	@ParamAnnotation(paramType = ProcedureParam.class)
	public void resetHistory() {
		log.debug("reseting");
		history = "";
		fireHistoryChange();
	}

	protected void fireHistoryChange() {
		for (EventListener<ChangeEvent> l : historyListeners) {
			ChangeEvent event = new ChangeEvent();
			event.history = history;
			l.action(event);
		}
	}

	@ParamAnnotation(id = "history_changed")
	public void addHistoryListener(EventListener<ChangeEvent> listener) {
		historyListeners.add(listener);
	}

	@ParamAnnotation(id = "history_changed")
	public void removeHistoryListener(EventListener<ChangeEvent> listener) {
		historyListeners.remove(listener);
	}

	@Override
	public String toString() {
		return "test class " + history;
	}

}
