package com.framsticks.params;

import java.util.HashMap;
import java.util.Map;

import com.framsticks.params.types.EventParam;
import com.framsticks.params.types.ProcedureParam;


/**
 * The Class PropertiesAccess.
 *
 * @author Jarek Szymczak <name.surname@gmail.com> (please replace name and
 *         surname with my personal data)
 *
 * @author Piotr Śniegowski
 */
public class PropertiesAccess extends SimpleAbstractAccess {

	public Map<String, Object> properties;

	@Override
	public Map<String, Object> createAccessee() {
		return PropertiesAccess.createPropertiesMap();
	}

	public static Map<String, Object> createPropertiesMap() {
		return new HashMap<String, Object>();
	}

	public PropertiesAccess(FramsClass framsClass) {
		super(framsClass);
	}

	@Override
	public void clearValues() {
		assert properties != null;
		properties.clear();
	}

	@Override
	public <T> T get(ValueParam param, Class<T> type) {
		assert properties != null;
		assert param != null;
		Object object = properties.get(param.getId());
		if (object != null) {
			try {
				return type.cast(object);
			} catch (ClassCastException e) {
				throw (ClassCastException) new ClassCastException("property " + param + " type is " + object.getClass().getName() + ", not " + type.getName()).initCause(e);
			}
		}
		try {
			return param.getDef(type);
		} catch (ClassCastException e) {
			throw (ClassCastException) new ClassCastException("default value of property " + param + " is not of type " + type.getName()).initCause(e);
		}

	}

	@Override
	protected <T> void internalSet(ValueParam param, T value) {
		properties.put(param.getId(), value);
	}

	/**
	 * Sets the new values to operate on. It does not check whether the values
	 * which are set through this method are correct. If set values are not
	 * correct exceptions might occurred while getting / setting the parameters
	 * values
	 *
	 * @param object
	 *            the properties with parameters values
	 */
	@SuppressWarnings("unchecked")
	@Override
	public PropertiesAccess select(Object object) {
		this.properties = (Map<String, Object>)object;
		return this;
	}

	/** covariant */
	@Override
	public Map<String, Object> getSelected() {
		return properties;
	}

	@Override
	public PropertiesAccess cloneAccess() {
		return new PropertiesAccess(framsClass);
	}

	@Override
	public void tryAutoAppend(Object object) {
		throw new InvalidOperationException();
	}

	@Override
	public Object call(String id, Object[] arguments) {
		throw new InvalidOperationException().msg("properties access does not support calling methods").arg("id", id);
	}

	@Override
	public Object call(ProcedureParam param, Object[] arguments) {
		throw new InvalidOperationException().msg("properties access does not support calling methods").arg("param", param);
	}

	@Override
	public void reg(EventParam param, EventListener<?> listener) {
		throw new InvalidOperationException().msg("properties access does not support registering events").arg("param", param).arg("access", this);
	}

	@Override
	public void regRemove(EventParam param, EventListener<?> listener) {
		throw new InvalidOperationException().msg("properties access does not support registering events").arg("param", param).arg("access", this);
	}

}
