package com.framsticks.params;



import static com.framsticks.util.lang.Containers.filterInstanceof;

import com.framsticks.params.types.EventParam;
import com.framsticks.params.types.ProcedureParam;

/**
 * @author Piotr Sniegowski
 */
public abstract class ListAccess implements AccessInterface {

	final AccessInterface elementAccess;
	final String containedTypeName;

	protected final ParamBuilder paramBuilder;

	public ListAccess(AccessInterface elementAccess) {
		this.elementAccess = elementAccess;
		this.containedTypeName = elementAccess.getId();
		paramBuilder = elementAccess.buildParam(new ParamBuilder());
	}

	// @Override
	// public Param getGroupMember(int gi, int n) {
	//	return null;
	// }

	@Override
	public void setDefault(boolean numericOnly) {
	}

	@Override
	public void setDefault(int i, boolean numericOnly) {
	}

	@Override
	public void setMin() {
	}

	@Override
	public void setMin(int i) {
	}

	@Override
	public void setMax() {
	}

	@Override
	public void setMax(int i) {
	}

	@Override
	public void save(SinkInterface sink) {
		for (CompositeParam p : filterInstanceof(getParams(), CompositeParam.class)) {
			Object child = get(p, Object.class);
			//this is probably an assertion
			assert child != null;
			elementAccess.select(child);
			elementAccess.save(sink);
		}
	}

	@Override
	public void load(SourceInterface stream) {
	}

	public AccessInterface getElementAccess() {
		return elementAccess;
	}

	/**
	 * @return the containedTypeName
	 */
	public String getContainedTypeName() {
		return containedTypeName;
	}

	@Override
	public final FramsClass getFramsClass() {
		return elementAccess.getFramsClass();
	}

	//TODO it could actually be used also
	@Override
	public void tryAutoAppend(Object object) {
		throw new InvalidOperationException();
	}

	@Override
	public Object call(String id, Object[] arguments) {
		throw new InvalidOperationException().msg("list access does not support calling methods").arg("id", id).arg("access", this);
	}

	@Override
	public Object call(ProcedureParam param, Object[] arguments) {
		throw new InvalidOperationException().msg("list access does not support calling methods").arg("param", param).arg("access", this);
	}

	@Override
	public void reg(EventParam param, EventListener<?> listener) {
		throw new InvalidOperationException().msg("list access does not support registering events").arg("param", param).arg("access", this);
	}

	@Override
	public void regRemove(EventParam param, EventListener<?> listener) {
		throw new InvalidOperationException().msg("list access does not support registering events").arg("param", param).arg("access", this);
	}


	@Override
	public String toString() {
		StringBuilder b = new StringBuilder();
		b.append("list of ").append(containedTypeName);
		if (getSelected() != null) {
			b.append("[").append(getParamCount()).append("]");
		}
		return b.toString();
	}
};
