package com.framsticks.params;

import com.framsticks.params.types.ArrayListParam;
import com.framsticks.util.UnimplementedException;
import com.framsticks.util.lang.Numbers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/**
 * @author Piotr Sniegowski
 */
public class ArrayListAccess extends ListAccess {

	List<Object> list;


	public ArrayListAccess(AccessInterface elementAccess) {
		super(elementAccess);
	}

	@Override
	public ArrayListAccess cloneAccess() throws ConstructionException {
		return new ArrayListAccess(elementAccess.cloneAccess());
	}

	@Override
	public List<?> createAccessee() {
		return new ArrayList<Object>();
	}

	@Override
	public CompositeParam getParam(int i) {
		if ((i < 0) ||  (i >= list.size())) {
			return null;
		}
		return paramBuilder.id(Integer.toString(i)).finish(CompositeParam.class);
	}

	@Override
	public CompositeParam getParam(String id) {
		Integer i = Numbers.parse(id, Integer.class);
		return (i == null ? null : getParam(i));
	}

	@Override
	public String getId() {
		return "l " + elementAccess.getId();
	}

	@Override
	public int getParamCount() {
		return list.size();
	}

	@Override
	public <T> T get(int i, Class<T> type) {
		if ((i < 0) ||  (i >= list.size())) {
			return null;
		}
		return type.cast(list.get(i));
	}

	@Override
	public <T> T get(String id, Class<T> type) {
		return get(Integer.parseInt(id), type);
	}

	@Override
	public <T> T get(ValueParam param, Class<T> type) {
		return get(param.getId(), type);
	}

	@Override
	public <T> int set(int i, T value) {
		while (i >= list.size()) {
			list.add(null);
		}
		list.set(i, value);
		return 0;
	}

	@Override
	public <T> int set(String id, T value) {
		return set(Integer.parseInt(id), value);
	}

	@Override
	public <T> int set(ValueParam param, T value) {
		return set(param.getId(), value);
	}

	@Override
	public void clearValues() {
		list.clear();
	}

	/** covariant */
	@Override
	public List<Object> getSelected() {
		return list;
	}

	@SuppressWarnings("unchecked")
	@Override
	public ArrayListAccess select(Object object) {
		list = (List<Object>) object;
		return this;
	}


	@Override
	public Iterable<Param> getParams() {
		return new Iterable<Param>() {

			@Override
			public Iterator<Param> iterator() {
				return new Iterator<Param>() {

					protected ListIterator<Object> internal = list.listIterator();

					@Override
					public boolean hasNext() {
						return internal.hasNext();
					}

					@Override
					public Param next() {
						Param param = paramBuilder.id(Integer.toString(internal.nextIndex())).finish(CompositeParam.class);
						internal.next();
						return param;
					}

					@Override
					public void remove() {
						throw new UnimplementedException().msg("remove element from list").arg("list", ArrayListAccess.this);

					}
				};
			}
		};
	}

	@Override
	public int getCompositeParamCount() {
		return list.size();
	}

	@Override
	public CompositeParam getCompositeParam(int number) {
		return getParam(number);
	}

	@Override
	public ParamBuilder buildParam(ParamBuilder builder) {
		return builder.name(containedTypeName + " list").type(ArrayListParam.class).containedTypeName(containedTypeName);
	}

}
