package com.framsticks.params;


import com.framsticks.params.types.EventParam;
import com.framsticks.params.types.ProcedureParam;


/**
 * The Interface AccessInterface. It's the most general class for storing data in
 * framsticks. In descriptions of methods names "property" and "parameter" are
 * synonyms.
 *
 * @author Jarek Szymczak <name.surname@gmail.com> (please replace name and
 *         surname with my personal data)
 */
public interface AccessInterface {

	Param getParam(int i);

	Param getParam(String id);

	String getId();

	int getParamCount();

	Object call(String id, Object[] arguments);

	Object call(ProcedureParam param, Object[] arguments);

	<T> T get(int i, Class<T> type);

	<T> T get(String id, Class<T> type);

	<T> T get(ValueParam param, Class<T> type);

	<T> int set(int i, T value);

	<T> int set(String id, T value);

	<T> int set(ValueParam param, T value);

	void reg(EventParam param, EventListener<?> listener);

	void regRemove(EventParam param, EventListener<?> listener);

	void setDefault(boolean numericOnly);

	void setDefault(int i, boolean numericOnly);

	void setMin();

	void setMin(int i);

	void setMax();

	void setMax(int i);

	void save(SinkInterface sink);

	void load(SourceInterface stream);

	/**
	 * Removes all the properties values.
	 */
	void clearValues();

	AccessInterface select(Object object);

	Object getSelected();

	AccessInterface cloneAccess() throws ConstructionException;

	Object createAccessee();

	Iterable<Param> getParams();

	FramsClass getFramsClass();

	void tryAutoAppend(Object object);

	int getCompositeParamCount();

	CompositeParam getCompositeParam(int number);

	ParamBuilder buildParam(ParamBuilder builder);


}
