package com.framsticks.gui.tree;

import java.util.LinkedList;
import java.util.List;


import com.framsticks.gui.ImageProvider;

public class MetaNode extends AbstractNode {

	protected List<AbstractNode> children = new LinkedList<>();
	protected String name = "meta node";

	/**
	 * @return the children
	 */
	public List<AbstractNode> getChildren() {
		return children;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	@Override
	public int getChildCount() {
		return children.size();
	}

	@Override
	public AbstractNode getChild(int number) {
		return children.get(number);
	}

	@Override
	public int getIndexOfChild(AbstractNode child) {
		return children.indexOf(child);
	}

	@Override
	public String toString() {
		return name;
	}

	@Override
	public boolean isLeaf() {
		return false;
	}

	@Override
	public void render(TreeCellRenderer renderer) {
		renderer.setIcon(ImageProvider.loadImage(ImageProvider.SERVER));
		renderer.setText(name);
		renderer.setToolTipText("?");
	}

}
