package com.framsticks.gui.tree;


import com.framsticks.gui.ImageProvider;
import com.framsticks.params.CompositeParam;

public class EmptyNode extends AbstractNode {

	protected final CompositeParam param;

	/**
	 * @param param
	 */
	public EmptyNode(CompositeParam param) {
		this.param = param;
	}

	@Override
	public int getChildCount() {
		return 0;
	}

	@Override
	public AbstractNode getChild(int number) {
		return null;
	}

	@Override
	public int getIndexOfChild(AbstractNode child) {
		return -1;
	}

	@Override
	public boolean isLeaf() {
		return true;
	}

	@Override
	public void render(TreeCellRenderer renderer) {
		renderer.setIcon(ImageProvider.loadImage(TreeCellRenderer.findIconName(param)));
		renderer.setText(param.getId());
		renderer.setToolTipText("?");
	}

	@Override
	public String toString() {
		return param.toString();
	}

}
