package com.framsticks.gui.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

import org.apache.log4j.Logger;

import com.framsticks.params.AccessInterface;
import com.framsticks.params.ListAccess;
import com.framsticks.params.PrimitiveParam;
import com.framsticks.util.UnsupportedOperationException;
import com.framsticks.util.lang.Casting;

public class TableModel implements javax.swing.table.TableModel {
	private static final Logger log =
		Logger.getLogger(TableModel.class);


	protected List<TableModelListener> listeners = new LinkedList<>();
	protected ListAccess access;
	protected AccessInterface elementAccess;
	protected final List<PrimitiveParam<?>> columnParams = new ArrayList<>();

	protected void refreshAll() {
		for (TableModelListener l : listeners) {
			l.tableChanged(new TableModelEvent(this));
		}

	}

	public void attachSource(ListAccess access) {
		this.access = Casting.assertCast(ListAccess.class, access.cloneAccess().select(access.getSelected()));

		this.elementAccess = this.access.getElementAccess().cloneAccess();
		log.debug("attached " + access);
		refreshAll();
	}

	@Override
	public void addTableModelListener(TableModelListener listener) {
		listeners.add(listener);
	}

	@Override
	public Class<?> getColumnClass(int columnIndex) {
		// log.debug("returning column type " + columnParams.get(columnIndex).getStorageType());
		return columnParams.get(columnIndex).getStorageType();
	}

	@Override
	public int getColumnCount() {
		// log.debug("returning column count " + columnParams.size());
		return columnParams.size();
	}

	@Override
	public String getColumnName(int columnIndex) {
		return columnParams.get(columnIndex).getName();
	}

	@Override
	public int getRowCount() {
		// log.debug("returning row count " + access.getParamCount());
		return access.getParamCount();
	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		assert (rowIndex < access.getParamCount() && columnIndex < columnParams.size());

		return elementAccess.select(access.get(rowIndex, Object.class)).get(columnParams.get(columnIndex), Object.class);
	}

	@Override
	public boolean isCellEditable(int rowIndex, int columnIndex) {
		return false;
	}

	@Override
	public void removeTableModelListener(TableModelListener listener) {
		listeners.remove(listener);
	}

	@Override
	public void setValueAt(Object value, int rowIndex, int columnIndex) {
		throw new UnsupportedOperationException().msg("setting value in table");

	}

	public void addColumn(PrimitiveParam<?> columnParam) {
		log.debug("added " + columnParam);
		columnParams.add(columnParam);
	}

	/**
	 * @return the columnParams
	 */
	public List<PrimitiveParam<?>> getColumnParams() {
		return Collections.unmodifiableList(columnParams);
	}

}
