package com.framsticks.gui.table;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import com.framsticks.gui.Panel;
import com.framsticks.gui.PanelProvider;
import com.framsticks.params.annotations.AutoAppendAnnotation;
import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.types.ListParam;

@FramsClassAnnotation
public class ListPanelProvider implements PanelProvider {

	protected final Map<String, ColumnsConfig> columnsConfigs = new HashMap<>();
	/**
 	 *
	 * That limit is honored only when no explicit ColumnsConfig object is found.
	 */
	protected Integer maximumColumnNumber = 5;

	@Override
	public Panel providePanel(Panel.Parameters parameters) {
		if (parameters.param instanceof ListParam) {
			return new ListPanel(parameters, this);
		}
		return null;
	}

	@AutoAppendAnnotation
	public void addColumnsConfig(ColumnsConfig config) {
		columnsConfigs.put(config.getClassName(), config);
	}

	/**
	 * @return the columnsConfigs
	 */
	public Map<String, ColumnsConfig> getColumnsConfigs() {
		return Collections.unmodifiableMap(columnsConfigs);
	}

	/**
	 * @return the maximumColumnNumber
	 */
	public Integer getMaximumColumnNumber() {
		return maximumColumnNumber;
	}

	/**
	 * @param maximumColumnNumber the maximumColumnNumber to set
	 */
	public void setMaximumColumnNumber(Integer maximumColumnNumber) {
		this.maximumColumnNumber = maximumColumnNumber;
	}

}
