package com.framsticks.gui.table;


import com.framsticks.gui.ModifiablePanel;
import com.framsticks.params.AccessInterface;
import com.framsticks.params.ListAccess;
import com.framsticks.params.PrimitiveParam;
import com.framsticks.util.lang.Casting;
import com.framsticks.util.lang.Containers;

import org.apache.log4j.Logger;

import javax.swing.*;

/**
 * Panel contains table and allows to manages displaying columns.
 */
@SuppressWarnings("serial")
public class ListPanel extends ModifiablePanel {

	private static final Logger log = Logger.getLogger(ListPanel.class.getName());

	protected final TableModel tableModel;
	protected final JTable table;
	protected final JScrollPane scrollPane;

	public ListPanel(Parameters parameters, ListPanelProvider provider) {
		super(parameters);

		final ColumnsConfig config = provider.getColumnsConfigs().get(framsClass.getName());
		log.debug("creating ListPanel for " + parameters.framsClass + " using config " + config);

		tableModel = new TableModel();
		if (config != null) {
			for (String id : config.getColumnsNames()) {
				tableModel.addColumn(framsClass.getParamEntry(id, PrimitiveParam.class));
			}
		} else {
			for (PrimitiveParam<?> param : Containers.filterInstanceof(framsClass.getParamEntries(), PrimitiveParam.class)) {
				if (provider.getMaximumColumnNumber() != null && tableModel.getColumnCount() >= provider.getMaximumColumnNumber()) {
					break;
				}
				tableModel.addColumn(param);
			}
		}

		table = new JTable(tableModel);
		scrollPane = new JScrollPane(table);
		setupContentComponent(scrollPane);

		table.getTableHeader().setReorderingAllowed(false);
		table.setColumnSelectionAllowed(false);
		table.setCellSelectionEnabled(false);
		table.setColumnSelectionAllowed(false);

		this.revalidate();
	}


	@Override
	protected void applyChanges() {
	}

	@Override
	public void pullValuesFromLocalToUser(AccessInterface access) {
		tableModel.attachSource(Casting.throwCast(ListAccess.class, access));
	}

	@Override
	public String getTitle() {
		return "List";
	}
}
