package com.framsticks.gui;

import com.framsticks.params.AccessInterface;
import com.framsticks.params.CompositeParam;
import com.framsticks.params.FramsClass;

import javax.swing.*;
import javax.swing.tree.TreePath;

import org.apache.log4j.Logger;

/**
 * Author: Piotr Śniegowski
 */
@SuppressWarnings("serial")
public abstract class Panel extends JPanel {

	private static final Logger log = Logger.getLogger(Panel.class);


	public static class Parameters {
		public final TreeAtFrame treeAtFrame;
		public final CompositeParam param;

		/** Contained type FramsClass. */
		public final FramsClass framsClass;

		public Parameters(TreeAtFrame treeAtFrame, CompositeParam param, FramsClass framsClass) {
			this.treeAtFrame = treeAtFrame;
			this.param = param;
			this.framsClass = framsClass;
		}
	}

	// private static final Logger log = Logger.getLogger(Panel.class.getName());

	protected TreePath currentTreePath;
	protected final TreeAtFrame treeAtFrame;
	protected final Frame frame;
	protected final String className;
	protected final FramsClass framsClass;
	protected final CompositeParam param;
	protected String uniqueName = "?";

	public Panel(Parameters parameters) {
		this.treeAtFrame = parameters.treeAtFrame;
		this.frame = parameters.treeAtFrame.getFrame();
		this.framsClass = parameters.framsClass;
		this.param = parameters.param;
		this.className = parameters.param.getContainedTypeName();
		this.setName(parameters.param.getFramsTypeName());
		log.debug("created panel: " + this);
	}



	public final Frame getFrame() {
		return frame;
	}

	/**
	 * @return the currentTreePath
	 */
	public TreePath getCurrentTreePath() {
		return currentTreePath;
	}

	/**
	 * @param currentTreePath the currentTreePath to set
	 */
	public void setCurrentTreePath(TreePath currentTreePath) {
		this.currentTreePath = currentTreePath;
	}

	public final TreeAtFrame getTreeAtFrame() {
		return treeAtFrame;
	}


	public final String getClassName() {
		return className;
	}

	public abstract void pullValuesFromLocalToUser(AccessInterface access);

	@Override
	public String toString() {
		return param.toString() + "(" + uniqueName + ")";
	}

	public final String getUniqueName() {
		return uniqueName;
	}

	public abstract String getTitle();
}
