package com.framsticks.gui;

import com.framsticks.gui.controls.Control;
import com.framsticks.gui.controls.ControlOwner;
import com.framsticks.gui.controls.ValueControl;
import com.framsticks.gui.controls.ValueControlListener;
import com.framsticks.params.AccessInterface;
import com.framsticks.params.Param;
import com.framsticks.params.ValueParam;

import org.apache.log4j.Logger;

import javax.swing.*;
import javax.swing.tree.TreePath;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import static com.framsticks.util.lang.Containers.filterInstanceof;

import com.framsticks.util.FramsticksException;

@SuppressWarnings("serial")
public class ObjectPanel extends ModifiablePanel implements ControlOwner {

	private static final Logger log = Logger.getLogger(ObjectPanel.class);

	final protected Map<Param, Control> components = new IdentityHashMap<Param, Control>();
	final protected Map<ValueParam, ValueControl> valueControls = new IdentityHashMap<ValueParam, ValueControl>();

	protected final JPanel contentPanel;
	protected final JScrollPane scrollPane;

	public ObjectPanel(Panel.Parameters parameters, Collection<Param> params) {
		super(parameters);

		contentPanel = new JPanel();
		scrollPane = new JScrollPane(contentPanel);
		contentPanel.setLayout(new BoxLayout(contentPanel, BoxLayout.PAGE_AXIS));
		setupContentComponent(scrollPane);

		Gui.fillWithControls(this, params, components, Control.class);
		setName(framsClass.getId());

		for (final ValueControl c : filterInstanceof(components.values(), ValueControl.class)) {
			valueControls.put(c.getParam(), c);
			c.setUserEnabled(true);
			c.setListener(new ValueControlListener() {
				@Override
				public boolean onChange(Object newValue) {
					if (currentTreePath == null) {
						return true;
					}
					boolean result = treeAtFrame.changeValue(currentTreePath, c, newValue);
					refreshControlButtons();
					return result;
				}
			});
		}

		contentPanel.add(Box.createVerticalGlue());
		this.revalidate();
	}

	@Override
	protected void applyChanges() {
		assert frame.isActive();
		assert currentTreePath != null;
		treeAtFrame.pushLocalChanges(currentTreePath);
	}

	protected void refreshControlButtons() {
		assert frame.isActive();
		applyButton.setEnabled(treeAtFrame.hasLocalChanges(currentTreePath));
	}

	protected static void fillControlsWithValues(Map<ValueControl, Object> map) {
	}

	@Override
	public void pullValuesFromLocalToUser(AccessInterface access) {
		assert currentTreePath != null;
		log.debug("refreshing components");

		final Map<ValueControl, Object> values = new IdentityHashMap<ValueControl, Object>();
		for (Map.Entry<ValueParam, ValueControl> e : valueControls.entrySet()) {
			values.put(e.getValue(), access.get(e.getKey().getId(), Object.class));
		}


		NodeAtFrame nodeAtFrame = treeAtFrame.getLocalInfo(currentTreePath);
		if (nodeAtFrame != null) {
			for (Map.Entry<ValueControl, Object> e : nodeAtFrame.localChanges.entrySet()) {
				values.put(e.getKey(), e.getValue());
			}
		}

		for (Map.Entry<ValueControl, Object> e : values.entrySet()) {
			e.getKey().pushValueToUserInterface(e.getValue());
		}
		refreshControlButtons();
		ObjectPanel.this.revalidate();

	}

	@Override
	public String getTitle() {
		return "Properties";
	}

	@Override
	public JPanel getPanelForControls() {
		return contentPanel;
	}

	@Override
	public void handle(FramsticksException exception) {
		frame.handle(exception);
	}

	@Override
	public TreePath getCurrentTreePath() {
		return super.getCurrentTreePath();
	}


}
