package com.framsticks.gui;

import java.awt.Dimension;
import java.util.Collection;
import java.util.Map;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

import org.apache.log4j.Logger;

import com.framsticks.gui.controls.CheckBoxControl;
import com.framsticks.gui.controls.Control;
import com.framsticks.gui.controls.ControlOwner;
import com.framsticks.gui.controls.EnumControl;
import com.framsticks.gui.controls.EventControl;
import com.framsticks.gui.controls.ProcedureControl;
import com.framsticks.gui.controls.SliderControl;
import com.framsticks.gui.controls.TextAreaControl;
import com.framsticks.gui.controls.TextFieldControl;
import com.framsticks.params.CompositeParam;
import com.framsticks.params.Param;
import com.framsticks.params.PrimitiveParam;
import com.framsticks.params.types.BinaryParam;
import com.framsticks.params.types.BooleanParam;
import com.framsticks.params.types.ColorParam;
import com.framsticks.params.types.DecimalParam;
import com.framsticks.params.types.EnumParam;
import com.framsticks.params.types.EventParam;
import com.framsticks.params.types.FloatParam;
import com.framsticks.params.types.ProcedureParam;
import com.framsticks.params.types.StringParam;
import com.framsticks.params.types.UniversalParam;
import com.framsticks.util.FramsticksException;
import com.framsticks.util.lang.Strings;

public final class Gui {

	private static final Logger log = Logger.getLogger(Gui.class.getName());

	private Gui() {
	}

	public static Control createComponentForText(PrimitiveParam<?> valueParam) {
		if (valueParam.getMax(Object.class) != null) {
			return new TextFieldControl(valueParam);
		}
		return new TextAreaControl(valueParam);


		// if (valueParam.getMin(Object.class) != null) {
		// 	return new TextAreaControl(valueParam);
		// }
		// return new TextFieldControl(valueParam);
	}

	public static Control createSuitable(Param param) {

		if (param instanceof EnumParam) {
			return new EnumControl((EnumParam) param);
		}
		if (param instanceof BooleanParam) {
			return new CheckBoxControl((BooleanParam) param);
		}
		if (param instanceof DecimalParam) {
			DecimalParam decimalParam = (DecimalParam)param;
			if (decimalParam.getMin(Integer.class) != null && decimalParam.getMax(Integer.class) != null) {
				return new SliderControl(decimalParam);
			}
			return new TextFieldControl(decimalParam);
		}
		if (param instanceof FloatParam) {
			FloatParam floatParam = (FloatParam)param;
			if (floatParam.getMin(Double.class) != null && floatParam.getMax(Double.class) != null) {
				return new SliderControl(floatParam);
			}
			return new TextFieldControl(floatParam);
		}
		if (param instanceof StringParam) {
			return createComponentForText((StringParam) param);
		}
		if (param instanceof ProcedureParam) {
			return new ProcedureControl((ProcedureParam) param);
		}
		if (param instanceof BinaryParam) {
			return new TextFieldControl((BinaryParam) param);
		}
		if (param instanceof ColorParam) {
			return new TextFieldControl((ColorParam) param);
		}
		if (param instanceof UniversalParam) {
			return new TextAreaControl((UniversalParam) param);
		}
		if (param instanceof EventParam) {
			return new EventControl((EventParam) param);
		}
		return null;
	}

	public static <P extends Param, C extends Control> void fillWithControls(ControlOwner owner, Collection<P> params, Map<P, C> components, Class<C> controlType) {
		JPanel panel = owner.getPanelForControls();
		for (P param : params) {
			if (param.isUserHidden()) {
				continue;
			}
			assert !(param instanceof CompositeParam);
			Control c = Gui.createSuitable(param);

			if (!controlType.isInstance(c)) {
				throw new FramsticksException().msg("created control is not of required type").arg("control", c).arg("type", controlType);
			}

			C control = controlType.cast(c);

			control.setOwner(owner);

			log.debug("add component for " + param);
			JPanel line = new JPanel();
			line.setLayout(new BoxLayout(line, BoxLayout.LINE_AXIS));
			line.setAlignmentX(JPanel.LEFT_ALIGNMENT);
			JLabel label = new JLabel(Strings.notEmpty(param.getName()) ? param.getName() : (Strings.notEmpty(param.getId()) ? param.getId() : "?"));
			label.setToolTipText(control.getToolTipText());
			label.setHorizontalAlignment(JLabel.RIGHT);
			Dimension labelSize = new Dimension(150, 30);
			label.setMaximumSize(labelSize);
			label.setMinimumSize(labelSize);
			label.setPreferredSize(labelSize);
			line.add(label);
			line.add(Box.createRigidArea(new Dimension(8, 0)));
			line.add(control);
			line.revalidate();
			panel.add(line);
			panel.add(Box.createRigidArea(new Dimension(0, 8)));
			//component.setAlignmentX(LEFT_ALIGNMENT);
			components.put(param, control);
		}

	}
}
