package com.framsticks.core;

import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.parsers.XmlLoader;
import com.framsticks.util.dispatching.Joinable;
import com.framsticks.util.dispatching.JoinableCollection;
import com.framsticks.util.dispatching.Monitor;

import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

import java.io.InputStream;

/**
 * @author Piotr Sniegowski
 */
@FramsClassAnnotation
public class Framsticks extends JoinableCollection<Joinable> {
	private static final Logger log = Logger.getLogger(Framsticks.class);

	public Framsticks() {
		PropertyConfigurator.configure(getClass().getResource("/configs/log4j.properties"));

		// log.info("config is: " + System.getProperties().getProperty("framsticks.config", "/configs/framsticks.xml"));
	}

	public static Framsticks loadConfiguration(InputStream stream) {
		return new XmlLoader().load(Framsticks.class, stream);
	}

	public static void main(final String[] args) {

		String config = "/configs/framsticks.xml";
		if (args.length != 0) {
			config = args[0];
		}

		new Monitor(loadConfiguration(Framsticks.class.getResourceAsStream(config))).use().waitFor().drop().join();

		log.debug("exiting main");
	}

	@Override
	public String toString() {
		return "framsticks";
	}

}
