// This file is a part of Framsticks SDK.  http://www.framsticks.com/
// Copyright (C) 1999-2020  Maciej Komosinski and Szymon Ulatowski.
// See LICENSE.txt for details.

#include "stdinoutfilesystem.h"
#include "stdiofile.h"

VirtFILE *StdInOutFileSystem::Vfopen(const char* path, const char*mode)
{
	if (isStdInOutPath(path))
	{
		if (*mode == 'r')
			return new StdioFILEDontClose(stdin);
		else
			return new StdioFILEDontClose(stdout);
	}
	return (chain != NULL) ? chain->Vfopen(path, mode) : NULL;
}

bool StdInOutFileSystem::isStdInOutPath(const char* path)
{
	return strcmp(path, "-") == 0;
}
