// This file is a part of Framsticks GDK library.
// Copyright (C) 2002-2006  Szymon Ulatowski.  See LICENSE.txt for details.
// Refer to http://www.frams.alife.pl/ for further information.

#ifndef _VIRTFILE_H_
#define _VIRTFILE_H_

#include <stdio.h>
#include <stdarg.h>
//#include <dirent.h>
struct dirent;

#ifdef DLLEXPORTACTIVE  //tylko w tym pliku uzyte
#define DLLEXP __declspec(dllexport)
#else
#define DLLEXP
#endif

class DLLEXP VirtFileSystem;

class DLLEXP VirtFILE
{
  public:
virtual int Vread(void *ptr, size_t size, size_t nmemb)=0;
virtual int Vwrite(const void *ptr, size_t size, size_t nmemb)=0;
virtual int Veof()=0;
virtual int Vputc(int c)=0;
virtual int Vputs(const char *s)=0;
virtual int Vgetc()=0;
virtual int Vseek(long offset, int whence)=0;
virtual int Vtell()=0;
virtual void Vrewind()=0;
virtual int Vflush()=0;
virtual char *Vgets(char *s, int size)=0;
virtual int Vprintf(const char *format, va_list args)=0;
int printf(const char *format, ...);
virtual const char *VgetPath() {return 0;} // 0=unspecified path
virtual ~VirtFILE();
static VirtFILE *Vstdin,*Vstdout,*Vstderr;
static void setVstdin(VirtFILE *);
static void setVstdout(VirtFILE *);
static void setVstderr(VirtFILE *);
static VirtFILE* getVstdin();
static VirtFILE* getVstdout();
static VirtFILE* getVstderr();
static VirtFileSystem *vfs;
static void selectFileSystem(VirtFileSystem *s);
};

class DLLEXP VirtDIR
{
  public:
virtual ~VirtDIR() {}
virtual dirent* Vreaddir() {return 0;}
};

class DLLEXP VirtFileSystem
{
public:
virtual VirtFILE *Vfopen(const char* path,const char*mode);
virtual int Vfexists(const char* path);
virtual VirtDIR *Vopendir(const char* path);
};

DLLEXP VirtFILE *Vfopen(const char* path,const char*mode);
DLLEXP VirtDIR *Vopendir(const char* path);
DLLEXP int Vfexists(const char* path);

DLLEXP int fread(void *ptr, size_t size, size_t nmemb, VirtFILE* f);
DLLEXP int fwrite(const void *ptr, size_t size, size_t nmemb, VirtFILE* f);
#ifdef __BORLANDC__
#undef feof
#endif
#ifdef _MSC_VER
#undef feof
#endif
DLLEXP int feof(VirtFILE* f);// {return f->Veof();}
#ifdef __BORLANDC__
#define feof(__f)     ((__f)->flags & _F_EOF)
#endif
#ifdef _MSC_VER
#define feof(_stream)     ((_stream)->_flag & _IOEOF)
#endif

DLLEXP int fputc(int c,VirtFILE* f);
DLLEXP int fputs(const char *s,VirtFILE* f);
DLLEXP int fgetc(VirtFILE* f);
DLLEXP int fseek(VirtFILE* f,long offset, int whence);
DLLEXP int ftell(VirtFILE* f);
DLLEXP void rewind(VirtFILE* f);
DLLEXP int fflush(VirtFILE* f);
DLLEXP char *fgets(char *s, int size, VirtFILE* f);
DLLEXP int fprintf(VirtFILE* f,const char *format, ...);
DLLEXP int fclose(VirtFILE* f);

DLLEXP dirent* readdir(VirtDIR* d);
DLLEXP int closedir(VirtDIR* d);

#endif
