// This file is a part of Framsticks GDK library.
// Copyright (C) 2002-2006  Szymon Ulatowski.  See LICENSE.txt for details.
// Refer to http://www.frams.alife.pl/ for further information.

#include "virtfile.h"

VirtFILE *VirtFILE::Vstdin=0;
VirtFILE *VirtFILE::Vstdout=0;
VirtFILE *VirtFILE::Vstderr=0;

VirtFileSystem *VirtFILE::vfs=0;

VirtFILE *Vfopen(const char* path,const char*mode)
{
return VirtFILE::vfs ? VirtFILE::vfs->Vfopen(path,mode) : 0;
}

VirtDIR *Vopendir(const char* path)
{
return VirtFILE::vfs ? VirtFILE::vfs->Vopendir(path) : 0;
}

int Vfexists(const char* path)
{
return VirtFILE::vfs ? VirtFILE::vfs->Vfexists(path) : 0;
}

VirtFILE::~VirtFILE()
{}

void VirtFILE::selectFileSystem(VirtFileSystem *s) {vfs=s;}

int VirtFILE::printf(const char *format, ...)
{
int ret; va_list argptr;
va_start(argptr,format);
ret=Vprintf(format,argptr);
va_end(argptr);
return ret;
}

void VirtFILE::setVstdin(VirtFILE *f) {Vstdin=f;}
void VirtFILE::setVstdout(VirtFILE *f) {Vstdout=f;}
void VirtFILE::setVstderr(VirtFILE *f) {Vstderr=f;}
VirtFILE* VirtFILE::getVstdin() {return Vstdin;}
VirtFILE* VirtFILE::getVstdout() {return Vstdout;}
VirtFILE* VirtFILE::getVstderr() {return Vstderr;}
//////////////////////////////////////////////////////////////////////////

VirtFILE* VirtFileSystem::Vfopen(const char* path,const char*mode) {return 0;}
int VirtFileSystem::Vfexists(const char* path) {return 0;}
VirtDIR* VirtFileSystem::Vopendir(const char* path) {return 0;}

//////////////////////////////////////////////////////////////////////////



int fread(void *ptr, size_t size, size_t nmemb, VirtFILE* f) {return f->Vread(ptr,size,nmemb);}
int fwrite(const void *ptr, size_t size, size_t nmemb, VirtFILE* f) {return f->Vwrite(ptr,size,nmemb);}
#ifdef __BORLANDC__
#undef feof
#endif
#ifdef _MSC_VER
#undef feof
#endif
int feof(VirtFILE* f) {return f->Veof();}
#ifdef __BORLANDC__
#define feof(__f)     ((__f)->flags & _F_EOF)
#endif
#ifdef _MSC_VER
#define feof(_stream)     ((_stream)->_flag & _IOEOF)
#endif

int fputc(int c,VirtFILE* f) {return f->Vputc(c);}
int fputs(const char *s,VirtFILE* f) {return f->Vputs(s);}
int fgetc(VirtFILE* f) {return f->Vgetc();}
int fseek(VirtFILE* f,long offset, int whence) {return f->Vseek(offset,whence);}
int ftell(VirtFILE* f) {return f->Vtell();}
void rewind(VirtFILE* f) {f->Vrewind();}
int fflush(VirtFILE* f) {return f->Vflush();}
char *fgets(char *s, int size, VirtFILE* f) {return f->Vgets(s,size);}
int fprintf(VirtFILE* f,const char *format, ...)
	{
	int ret; va_list argptr;
	va_start(argptr,format);
	ret=f->Vprintf(format,argptr);
	va_end(argptr);
	return ret;
	}
int fclose(VirtFILE* f) {delete f; return 0;}

int closedir(VirtDIR* d) {delete d; return 0;}
dirent* readdir(VirtDIR* d) {return d->Vreaddir();}
