// This file is a part of Framsticks GDK library.
// Copyright (C) 2002-2006  Szymon Ulatowski.  See LICENSE.txt for details.
// Refer to http://www.frams.alife.pl/ for further information.

#ifndef _SSTRINGUTILS_H_
#define _SSTRINGUTILS_H_

#include "sstring.h"
#include "virtfile.h"

/// return: 1=ok 0=error
int loadSString(const char* filename,SString& s,const char* framsgmodule=0,const char* error=0);
void loadSString(VirtFILE *f,SString& s);

int quoteTilde(SString &target);
int unquoteTilde(SString &target);

bool strContainsOneOf(const char* str,const char* chars);
bool sstringQuote(SString& target);
const char* skipQuoteString(const char* txt, const char* limit);
int sstringUnquote(SString &target);

int strFindField(const SString& txt,const SString& name,int &end);
SString strGetField(const SString& txt,const SString& name);
void strSetField(SString& txt,const SString& name,const SString& value);

#endif

