// This file is a part of Framsticks GDK library.
// Copyright (C) 2002-2006  Szymon Ulatowski.  See LICENSE.txt for details.
// Refer to http://www.frams.alife.pl/ for further information.

//Define rnd01, rnd0N, and randomN so that they
//work in your C++ environment.
//Some other functions/macros may also be needed if they
//are missing in your environment, like min, max, etc.

#ifndef __NONSTD_H
#define __NONSTD_H

#define APPLICATION_NAME "Framsticks"
#define MAIN_FRAMSTICKS
#define SAFEDELETE(p) {if (p) {delete p; p=NULL;}}
#define SAFEDELETEARRAY(p) {if (p) {delete[] p; p=NULL;}}

//#ifndef _Windows   included below?
//#include <stdlib.h>
//#endif

#define DB(x) //output debug info. If needed, use #define DB(x) x
//#define DB(x) x

// ms visual c++
#ifdef _MSC_VER
 #define WIN32_LEAN_AND_MEAN     // Exclude rarely-used stuff from Windows headers
 #include <windows.h>
 #include <stdio.h>
 #include <stdarg.h>
 #define vsnprintf _vsnprintf
 #define _USE_MATH_DEFINES

 #ifndef M_PI
 #define M_PI 3.1415926535897932384626433832795
 #endif
 #ifndef M_PI_2
 #define M_PI_2 (M_PI/2)
 #endif

#endif

/////////////////////////////////////////////////////// 64-bit int type and other macros
#ifdef _Windows
	typedef __int64 LONGLONG;
	#define PATHSEPARATORCHAR '\\'
	#define PATHSEPARATORSTRING "\\"
	#define FPU_THROWS_EXCEPTIONS
#else
	#define LONGLONG long long int
	#define PATHSEPARATORCHAR '/'
	#define PATHSEPARATORSTRING "/" 
#endif

#ifdef __BORLANDC__
	#define fileExists(f) (!access(f,0))
        #include "stdlib.h" //random
	#define FOPEN_READ "rt"
	#define FOPEN_WRITE "wt"
	#define FOPEN_APPEND "at"
	#define rnd01 ((double)((double)_lrand()/(double)(LRAND_MAX+1)))
	//#define rnd01 ((double)((double)rand()/(RAND_MAX+1)))
	#define rnd0N(num) ((double)((num)*rnd01))
	#define randomN(num) random(num) //uses _lrand
#else
	#ifdef _MSC_VER
	#define fileExists(f) (!access(f,0))
	#else
	#define fileExists(f) (!access(f,R_OK))
	#endif

	#define FOPEN_WRITE "wa"
	#define FOPEN_APPEND "aa"
	#define FOPEN_READ "ra"
	//#define FLOATRAND
	#ifdef FLOATRAND
		#define randomN(x) ((int)((x)*drand48()))
		#define rnd01 (drand48())
  		#define rnd0N(x) (drand48()*(x))
	#else
		#define rnd01 ((double)(rand()/(RAND_MAX+1.0)))
		#define rnd0N(x) ((x)*rnd01)
		#define randomN(x) ((int)rnd0N(x))
	#endif
#endif


#ifdef __GNUC__
/*
	#define min(a,b) (((a)>(b))?(b):(a))
	#define max(a,b) (((a)>(b))?(a):(b))
	#define abs(a) ((a)>=0?(a):-(a))
*/
#include <algorithm>
using namespace std;
#endif

#endif
