// This file is a part of Framsticks GDK library.
// Copyright (C) 2002-2006  Szymon Ulatowski.  See LICENSE.txt for details.
// Refer to http://www.frams.alife.pl/ for further information.

#ifndef _NILIBRARY_H_
#define _NILIBRARY_H_

#include "advlist.h"
#include "param.h"

class NeuroClass;

class NeuroLibrary
{
  public:
static NeuroLibrary staticlibrary;
NeuroLibrary();
~NeuroLibrary();
AdvList classes;
NeuroClass* findClass(const SString& classname, bool activeonly=1);
void addStandardClasses();
int findClassIndex(const SString& classname, bool activeonly=1);
NeuroClass* getClass(int classindex) {return (NeuroClass*)classes(classindex);}
int getClassCount() {return classes.size();}
void removeClass(int i);
void clear();
NeuroClass *addClass(NeuroClass *cls,bool replace=1);
};

#endif
