// This file is a part of Framsticks GDK library.
// Copyright (C) 2002-2006  Szymon Ulatowski.  See LICENSE.txt for details.
// Refer to http://www.frams.alife.pl/ for further information.

#include "neurolibrary.h"
#include "param.h"
#include "modelparts.h"

NeuroLibrary NeuroLibrary::staticlibrary;

int NeuroLibrary::findClassIndex(const SString & classname, bool activeonly)
{
NeuroClass* cl;
for(int i=0;cl=(NeuroClass*)classes(i);i++)
	{
	if (activeonly && !cl->active) continue;
	if (classname == cl->getName()) return i;
	}
return -1;
}

NeuroClass* NeuroLibrary::findClass(const SString & classname, bool activeonly)
{
int i=findClassIndex(classname,activeonly);
if (i<0) return 0;
return getClass(i);
}

NeuroClass *NeuroLibrary::addClass(NeuroClass *cls,bool replace)
{
NeuroClass *old=findClass(cls->getName());
if (old)
	{
	if (replace)
		{
		classes-=old;
		classes+=cls;
		}
	}
else
	classes+=cls;
return old;
}

void NeuroLibrary::addStandardClasses()
{
#include "neurocls-library.h"
}

NeuroLibrary::NeuroLibrary()
{
addStandardClasses();
}

NeuroLibrary::~NeuroLibrary()
{
FOREACH(NeuroClass*,cl,classes)
	delete cl;
}

void NeuroLibrary::removeClass(int i)
{
classes-=i;
}

void NeuroLibrary::clear()
{
while(getClassCount()>0)
	removeClass(getClassCount()-1);
}

