// This file is a part of Framsticks GDK library.
// Copyright (C) 2002-2006  Szymon Ulatowski.  See LICENSE.txt for details.
// Refer to http://www.frams.alife.pl/ for further information.

#include "geno.h"
#include "stdiofile.h"
#include "sstringutils.h"
#include "defgenoconv.h"

/**
 @file
 Sample code: Testing genotype validity

 \include genotest.cpp
*/

DefaultGenoConvManager gcm; //without this object the application would only handle "format 0" genotypes

int main(int argc,char*argv[])
{
if (argc<=1)
	{
	puts("no genotype");
	return 10;
	}
SString gen(argv[1]);
if (!strcmp(gen,"-"))
	{
	gen=0;
	StdioFILEDontClose in(stdin);
	loadSString(&in,gen);
	}
Geno g(gen);
puts(g.isValid()?"valid":"invalid");
return !g.isValid();
}
