// This file is a part of Framsticks GDK library.
// Copyright (C) 2002-2006  Szymon Ulatowski.  See LICENSE.txt for details.
// Refer to http://www.frams.alife.pl/ for further information.

#ifndef _CONV_F1_H
#define _CONV_F1_H

#include "genoconv.h"
#include "model.h"

struct F1Props
{
	double dlug,skr,masa,tarcie,ruch,asym,odpor,wchl,rot,energ;
	double bendrange;
	int resetrange;
	void wykluczanie();
};

/**
 Official framsticks f1 -> f0 converter.
 Source code is published as educational example, but currently not
 well documented.
 This converter features building creature using Model class
 and some advanced tricks (changing model data during construction).
 Final f0 genotype is generated by model class.

 <b>GDK 1.0.5 NN extension: (for Framsticks 2.0)</B>

 Until now, only the "standard" Framsticks v1 neuron classes could be used.
 Starting with GDK 1.0.5 you can use all neuron types.

 \b Syntax: [classname , input_or_parameter:weight , input_or_parameter:weight , ...]

 The classname is optional, the default class will be used if it is omitted.
 Note the comma after \b classname. It must be present if you provide the classname.
 This is to distinguish between old muscle syntax and new classname specification:
 - "[|,0:1]" is the neuron of class "|" (bend muscle) with one self connection.
 \image html nn-ex1.gif
 - "[|0:1]" describes the default neuron class (N) connected with the bend muscle (|).
 \image html nn-ex2.gif


 Neuron parameters can be specified along with inputs, eg: "[myclass,param1:34,param2:56]"
 The names beginning with UPPER case character are assumed to be neuron classes.
 "[myclass,g:1.23,G:2.34]" - the first 'g' is the parameter, the second one is the receptor
 G ("gyroscope").

 Another example:

 "X[G][-1:2.3][-2:3.4]" - The first neuron is the standalone G receptor. Other neuron can use its output 
 signal by specifying it as regular input ("-1:2.3" and "-2:3.4"). This NN contains 3 neurons.
 \image html nn-ex3.gif

 "X[G:2.3][G:3.4]" - with the old syntax it is impossible to connect 2 neurons with the same gyroscope,
 because everything inside brackets is private to the neuron, others can't refer to it.
 Adding another neuron with "G" input will add another gyroscope object. This NN contains 4 neurons
 (or 2 neurons if you try it in Framsticks v1).
  \image html nn-ex4.gif
 
*/
class GenoConv_F1: public GenoConverter
{
public:
GenoConv_F1()
	{
	name="f1 converter";
	in_format='1';
	mapsupport=1;
	info="Original Framsticks genotype format";
	}
SString convert(SString &i,MultiMap *map);
~GenoConv_F1() {}
};


#endif





