// This file is a part of Framsticks GDK library.
// Copyright (C) 2002-2006  Szymon Ulatowski.  See LICENSE.txt for details.
// Refer to http://www.frams.alife.pl/ for further information.

#include "nonstd.h"
#include "syntparam.h"
#include "paramobj.h"
#include <math.h>

SyntParam::SyntParam(ParamEntry *init_pe,SString* autostr)
	:autostring(autostr)
{
Param::setParamTab(init_pe);
pe=ParamObject::makeParamTab(this);
Param::setParamTab(pe);
obj=ParamObject::makeObject(pe);
Param::select(obj);
Param::setDefault();
revert();
}

SyntParam::SyntParam(const SyntParam& src)
	:autostring(src.autostring)
{
Param::setParamTab(src.pe);
pe=ParamObject::makeParamTab(this);
Param::setParamTab(pe);
obj=ParamObject::dupObject(src.obj);
Param::select(obj);
}

SyntParam::~SyntParam()
{
update();
ParamObject::freeParamTab(pe);
ParamObject::freeObject(obj);
}

void SyntParam::update(SString *s)
{
if (!s) s=autostring;
if (s) {*s=""; Param::save2(*s,0,0);}
}

void SyntParam::revert(SString *s)
{
if (!s) s=autostring;
if (s)	{
	int p=0;
	Param::load2(*s,p);
	}
}





