// This file is a part of Framsticks GDK library.
// Copyright (C) 2002-2006  Szymon Ulatowski.  See LICENSE.txt for details.
// Refer to http://www.frams.alife.pl/ for further information.

#ifndef _STDIOFILE_H_
#define _STDIOFILE_H_

#include "virtfile.h"
#include "sstring.h"
#include <stdio.h>
#ifndef _MSC_VER
#include <dirent.h>
#endif

class StdioFileSystem: public VirtFileSystem
{
public:
VirtFILE *Vfopen(const char* path,const char*mode);
int Vfexists(const char* path);
VirtDIR *Vopendir(const char* path);
};

class StdioFILE: public VirtFILE
{
  protected:
FILE *file;
SString path;
  public:
StdioFILE(FILE *f) {file=f;}
StdioFILE(FILE *f,const SString& p) {file=f;path=p;}
static void setStdio();
int Vread(void *ptr, size_t size, size_t nmemb) {return fread(ptr,size,nmemb,file);}
int Vwrite(const void *ptr, size_t size, size_t nmemb) {return fwrite(ptr,size,nmemb,file);}
int Veof() {return feof(file);}
int Vputc(int c) {return fputc(c,file);}
int Vputs(const char *s) {return fputs(s,file);}
int Vgetc() {return fgetc(file);}
char *Vgets(char *s, int size) {return fgets(s,size,file);}
int Vprintf(const char *format, va_list args) { return vfprintf(file,format,args); }
int Vseek(long offset, int whence) {return fseek(file,offset,whence);}
int Vtell() {return ftell(file);}
void Vrewind() {rewind(file);}
int Vflush() {return fflush(file);}
const char* VgetPath() {return path;}

~StdioFILE() {if (file) fclose(file);}
};

class StdioDIR: public VirtDIR
{
#ifndef _MSC_VER
DIR *dir;
  public:
StdioDIR(DIR* d):dir(d) {}
~StdioDIR() {if (dir) closedir(dir);}
dirent* Vreaddir();
#endif
};

class StdioFILEDontClose: public StdioFILE
{
  public:
StdioFILEDontClose(FILE *f):StdioFILE(f) {}
~StdioFILEDontClose() {file=0;}
};

#endif
