// This file is a part of Framsticks GDK library.
// Copyright (C) 2002-2006  Szymon Ulatowski.  See LICENSE.txt for details.
// Refer to http://www.frams.alife.pl/ for further information.

#include "stdiofile.h"
#include "nonstd.h"
#include "nonstd_io.h"

VirtFILE* StdioFileSystem::Vfopen(const char* path,const char*mode)
{
FILE *f=fopen(path,mode);
if (f) return new StdioFILE(f,path); else return 0;
}

VirtDIR* StdioFileSystem::Vopendir(const char* path)
{
#ifndef _MSC_VER
DIR *d=opendir(path);
if (d) return new StdioDIR(d); else
#endif
return 0;
}

int StdioFileSystem::Vfexists(const char* path)
{return fileExists(path);}

void StdioFILE::setStdio()
{
static StdioFILEDontClose si(stdin);
static StdioFILEDontClose so(stdout);
static StdioFILEDontClose se(stderr);
setVstdin(&si);
setVstdout(&so);
setVstderr(&se);
}

#ifndef _MSC_VER
dirent* StdioDIR::Vreaddir()
{
return readdir(dir);
}
#endif
