// This file is a part of Framsticks GDK library.
// Copyright (C) 2002-2006  Szymon Ulatowski.  See LICENSE.txt for details.
// Refer to http://www.frams.alife.pl/ for further information.

#include "sstringutils.h"
#include "virtfile.h"
#include "framsg.h"

int loadSString(const char* filename,SString& s,const char* framsgmodule,const char* error)
{
VirtFILE *f;
int ret=0;
if (f=Vfopen(filename,"rb"))
	{
	loadSString(f,s);
	ret=1;
	fclose(f);
	}
else if (framsgmodule)
	FMprintf(framsgmodule,"loadSString",FMLV_WARN,error?error:"can't open file \"%s\"",filename);
return ret;
}

void loadSString(VirtFILE *f,SString& s)
{
static char buf[4000];
int len;
while(!f->Veof())
	{
	len=fread(buf,1,4000,f);
	s.append(buf,len);
	}
}

//////////////////////////

/** "x~xx~xxx" -> "x\~xx\~xxx"  */
int quoteTilde(SString &target)
{
const char* x=target;
SString tmp;
char *f;
while(1)
	{
	f=strchr((char*)x,'~');
	if (f)
		{
		tmp.append(x,f-x);
		tmp+="\\~";
		x=f+1;
		}
	else
		{
		if (tmp.len()==0) return 0; // nothing was changed!
		tmp+=x;
		target=tmp;
		return 1;
		}
	}
}

/** "x\~xx\~xxx" -> "x~xx~xxx"  */
int unquoteTilde(SString &target)
{
const char* x=target;
SString tmp;
char *f;
while(1)
	{
	f=strchr((char*)x,'\\');
	if (f)
		{
		tmp.append(x,f-x);
		if (f[1]=='~')
			{
			tmp+='~';
			x=f+2;
			}
		else
			{
			tmp+="\\";
			x=f+1;
			}
		}
	else
		{
		if (tmp.len()==0) return 0; // nothing was changed!
		tmp+=x;
		target=tmp;
		return 1;
		}
	}
}

/////////////////

bool strContainsOneOf(const char* str,const char* chars)
{
while(*str)
	{
	if (strchr(chars,*str)) return 1;
	str++;
	}
return 0;
}

//////////////

bool sstringQuote(SString& target)
{
const char* x=target;
bool changed=0;
SString tmp;
tmp.memoryHint(target.len());
while(*x)
	{
	switch(*x)
		{
		case '\n': tmp+="\\n"; changed=1; break;
		case '\r': tmp+="\\r"; changed=1; break;
		case '\t': tmp+="\\t"; changed=1; break;
		case '\"': tmp+="\\\""; changed=1; break;
		default: tmp+=*x;
		}
	x++;
	}
if (changed) target=tmp;
return changed;
}

const char* skipQuoteString(const char* txt, const char* limit)
{
while(*txt)
	{
	if (*txt=='\"') return txt;
	if (*txt=='\\') txt++;
	txt++;
	if (txt==limit) break;
	}
return txt;
}

int sstringUnquote(SString &target)
{
const char* x=target;
SString tmp;
char *f;
while(1)
	{
	f=strchr((char*)x,'\\');
	if (f)
		{
		tmp.append(x,f-x);
		switch(f[1])
			{
			case 'n': tmp+='\n'; break;
			case 'r': tmp+='\r'; break;
			case 't': tmp+='\t'; break;
			case '\"': tmp+='\"'; break;
			default: tmp+=f[1];
			}
		x=f+2;
		}
	else
		{
		if (tmp.len()==0) return 0; // nothing was changed!
		tmp+=x;
		target=tmp;
		return 1;
		}
	}
}

int strFindField(const SString& txt,const SString& name,int &end)
{
const char* t=txt,*n;
int pos=0;
while(1)
	{
	n=strchr(t+pos,',');
	if ((!strncmp(t+pos,name,name.len()))&&(t[pos+name.len()]=='='))
		{
		if (n) end=n-t; else end=txt.len();
		return pos;
		}
	if (n) pos=n-t+1; else break;
	}
return -1;
}

SString strGetField(const SString& txt,const SString& name)
{
int p,e;
p=strFindField(txt,name,e);
if (p<0) return SString();
p+=name.len()+1;
return SString(txt.substr(p,e-p));
}

void strSetField(SString& txt,const SString& name,const SString& value)
{
int p,e;
p=strFindField(txt,name,e);
if (p<0)
	{
	if (!value.len()) return;
	char *t=txt.directAppend(1+name.len()+value.len());
	char *b=t;
	if (txt.len()) *(t++)=',';
	strcpy(t,name); t+=name.len();
	*(t++)+='=';
	strcpy(t,value); t+=value.len();
	txt.endAppend(t-b);
	}
else
	{
	if (!value.len())
		{
		if (p>0) p--; else if (e<txt.len()) e++;
		char *t=txt.directWrite(0);
		memmove(t+p,t+e,txt.len()-e);
		txt.endWrite(txt.len()+value.len()-(e-p));
		}
	else
		{
		p+=name.len()+1;
		char *t=txt.directWrite(txt.len()+value.len()-(e-p));
		memmove(t+p+value.len(),t+e,txt.len()-e);
		memmove(t+p,value,value.len());
		txt.endWrite(txt.len()+value.len()-(e-p));
		}
	}
}

