// This file is a part of Framsticks GDK library.
// Copyright (C) 2002-2006  Szymon Ulatowski.  See LICENSE.txt for details.
// Refer to http://www.frams.alife.pl/ for further information.

#ifndef _PARAMOBJ_H_
#define _PARAMOBJ_H_

#include "param.h"

class ParamObject
{
  public:
/** make a ParamEntry* array for use with Param object.
    offsets in the array are calculated for the ExtObject array as the target.
    valid array can be created with makeObject().
    sample code:
    @code
    ParamInterface *pi=...; // any param interface
    ParamEntry *tab=ParamObject::makeParamTab(pi);
    void* obj=ParamObject::makeObject(tab);
    void* obj2=ParamObject::makeObject(tab);
    Param par(tab,obj);
    par.set(...), par.get(...), par.load(...), par.save(...);
    par.select(obj);
    par.select(obj2);
    ParamObject::freeObject(obj);
    ParamObject::freeObject(obj2);
 */
static ParamEntry* makeParamTab(ParamInterface *pi,bool stripgroups=0,bool stripproc=0,int firstprop=0,int maxprops=9999,bool dupentries=false, int flagsexclude=0);

/** deallocate paramtab obtained from makeParamTab() */
static void freeParamTab(ParamEntry *pe);

/** @return the object, suitable for Param.select(...).
    @return NULL if 'pi' has no usable properties */
static void* makeObject(ParamEntry *tab);

/** copy data from src to dst  */
static void copyObject(void* dst,void* src);

/** duplicate object */
static void* dupObject(void* obj);

/** delete all data in the array and deallocate it  */
static void freeObject(void* obj);
};

#endif
