// This file is a part of Framsticks GDK library.
// Copyright (C) 2002-2006  Szymon Ulatowski.  See LICENSE.txt for details.
// Refer to http://www.frams.alife.pl/ for further information.

#include "paramobj.h"
#include "extvalue.h"

static const char* maybedup(bool dup,const char* src)
{ return dup ? (src?strdup(src):0) : src; }
static void maybefree(void* mem)
{ if (mem) free(mem); }

ParamEntry* ParamObject::makeParamTab(ParamInterface *pi,bool stripgroups,bool stripproc,
				      int firstprop, int maxprops, bool dupentries, int flagsexclude)
{
ParamEntry *tab,*t;
int i,n,offs;
static ExtValue ex;
int count=0,gcount=1;
if (!stripgroups) gcount=pi->getGroupCount();
if (stripproc||flagsexclude)
for (int i=firstprop;i < pi->getPropCount();i++)
	{
	const char*t=pi->type(i);
	if ((!stripproc)||(strchr("dfsox",*t)))
		if ((!flagsexclude)||(!(pi->flags(i)&flagsexclude)))
			if (++count >= maxprops) break;
	}
else count=pi->getPropCount()-firstprop;
t=tab=(ParamEntry*)malloc(sizeof(ParamEntry)*(count+gcount+1));
t->group=gcount;
t->flags=count;
t->name=maybedup(dupentries,pi->getName());
t->type=maybedup(dupentries,pi->getDescription());
for(i=0;i<gcount;i++)
	{
	t->id=maybedup(dupentries,pi->grname(i));
	t->offset=0;
	t++;
	}
n=1; offs=1;
for (i=firstprop;i < pi->getPropCount();i++)
	{
	if ((!stripproc)||(strchr("dfsox",*pi->type(i))))
		{
		if ((!flagsexclude)||(!(pi->flags(i)&flagsexclude)))
			{
			t->offset=offs*sizeof(ExtValue);
			if (*pi->type(i)!='x') t->offset+=(((char*)&ex.data[0])-((char*)&ex));
			t->group=stripgroups?0:pi->group(i);
			t->flags=pi->flags(i);
			t->fun1=0;
			t->fun2=0;
			t->id=maybedup(dupentries,pi->id(i));
			t->name=maybedup(dupentries,pi->name(i));
			t->type=maybedup(dupentries,pi->type(i));
			t->help=maybedup(dupentries,pi->help(i));
			t++;
			n++;
			if (n>count) break;
			}
		offs++;
		}
	}
t->id=0; t->group=0; t->flags=dupentries?MUTPARAM_ALLOCENTRY:0;
return tab;
}

void ParamObject::freeParamTab(ParamEntry *pe)
{
if (pe[pe->flags+pe->group].flags & MUTPARAM_ALLOCENTRY)
	{
	int i;
	ParamEntry *e;
	maybefree((void*)pe->name);
	maybefree((void*)pe->type);
	for (i=0,e=pe;i<pe->group;i++,e++) 
		maybefree((void*)e->id);
	for (i=pe->group,e=pe+i;i<pe->group+pe->flags;i++,e++) 
		{
		maybefree((void*)e->id);
		maybefree((void*)e->name);
		maybefree((void*)e->type);
		maybefree((void*)e->help);
		}
	}
free(pe);
}

void* ParamObject::makeObject(ParamEntry *tab)
{
if (!tab) return 0;
int n=tab->flags;
if (!n) return 0;
ExtValue *ret,*v;
ret=v=(ExtValue*)malloc( sizeof(ExtValue)*(n+1) );
for (int i=0;i<=n;i++,v++)
	new(v) ExtValue;
ret->setInt(n);
v=ret+1;
tab+=tab->group;
for (;n>0;n--,v++,tab++)
	switch(*tab->type)
	{
	case 'd': v->setInt(0); break;
	case 'f': v->setDouble(0); break;
	case 's': v->setString(SString::empty); break;
	case 'o': v->setObject(ExtObject()); break;
	case 'x': break;
	}
return ret;
}

void ParamObject::copyObject(void* dst,void* src)
{
if ((!dst)||(!src)) return;
ExtValue *s=(ExtValue *)src;
ExtValue *d=(ExtValue *)dst;
int n=min(s->getInt(),d->getInt());
s++; d++;
for (int i=0;i<n;i++,d++,s++)
	*d=*s;
}

void* ParamObject::dupObject(void* src)
{
if (!src) return 0;
ExtValue *s=(ExtValue *)src;
int n=s->getInt();

ExtValue *ret=new ExtValue[n+1];
ExtValue *d=ret;
d->setInt(n);
d++; s++;

for (int i=0;i<n;i++,d++,s++)
	*d=*s;

return ret;
}

void ParamObject::freeObject(void* obj)
{
if (!obj) return;
ExtValue *o=(ExtValue *)obj,*t=o+1;
int n=o->getInt();
for (int i=0;i<n;i++,t++)
	t -> ~ExtValue();
free(obj);
}









