// This file is a part of Framsticks GDK library.
// Copyright (C) 2002-2006  Szymon Ulatowski.  See LICENSE.txt for details.
// Refer to http://www.frams.alife.pl/ for further information.

#include <stdio.h>
#include <ctype.h>

#include "param.h"
#include "extvalue.h"
#include "framsg.h"
#include "sstringutils.h"

//#define SAVE_ALL_NAMES
#define SAVE_SELECTED_NAMES
#define WARN_MISSING_NAME

char MakeCodeGuardHappy;

ParamEntry empty_paramtab[]=
{ {"Empty",1,0,"Empty",}, {0,0,0,}, }; 

static void czytdotyldy(VirtFILE *f,SString &s)
{
SString temp;
int z;
char last_char=0;
while((z=fgetc(f))!=EOF)
	{
	if (z=='~')
		if (last_char!='\\') break;
	last_char=(char)z;
	temp+=last_char;
	}
s=temp;
}

static const char *strchrlimit(const char *t,int ch,const char *limit)
{
int n=limit-t;
for (;(n>0)&&*t;t++,n--)
	if (*t==ch) return t;
return 0;
}

static char* fgets0(char*t,int d,VirtFILE *f, bool& eolfound)
{
char *r=fgets(t,d,f);
eolfound=false;
if (r)
	{
	int d=strlen(r);
	while (d-- > 0) if ((r[d]=='\r')||(r[d]=='\n')) {r[d]=0; eolfound=true;} else break;
	}
return r;
}

void ParamInterface::copyFrom(ParamInterface *src)
{
int n=getPropCount();
ExtValue v;
int j;
for(int i=0;i<n;i++)
  if ((!(flags(i)&PARAM_READONLY))
	  && (*type(i)!='p'))
	{
	j=src->findId(id(i));
	if (j<0) continue;
	src->get(j,v);
	set(i,v);
	}
}

void ParamInterface::quickCopyFrom(ParamInterface *src)
{
int n=getPropCount();
ExtValue v;
for(int i=0;i<n;i++)
  if ((!(flags(i)&PARAM_READONLY))
	  && (*type(i)!='p'))
	  {
	  src->get(i,v);
	  set(i,v);
	  }
}

int ParamInterface::getMinMax(int prop,long& minumum,long& maximum,long &def)
{
const char* t=type(prop)+1;
while(*t) if (*t==' ') break; else t++;
return sscanf(t,"%ld %ld %ld",&minumum,&maximum,&def);
}

int ParamInterface::getMinMax(int prop,double& minumum,double& maximum,double& def)
{
const char* t=type(prop)+1;
while(*t) if (*t==' ') break; else t++;
return sscanf(t,"%lg %lg %lg",&minumum,&maximum,&def);
}

void ParamInterface::setDefault(bool numericonly)
{
int n=getPropCount();
for(int i=0;i<n;i++)
	setDefault(i,numericonly);
}

void ParamInterface::setMin()
{
int n=getPropCount();
for(int i=0;i<n;i++)
	setMin(i);
}

void ParamInterface::setMax()
{
int n=getPropCount();
for(int i=0;i<n;i++)
	setMax(i);
}

void ParamInterface::setDefault(int i,bool numericonly)
{
const char *t=type(i);
switch(*t)
	{
	case 'f':
	{
	double a=0,b=0,c=0;
	getMinMax(i,a,b,c);
	setDouble(i,c);
	}
	break;
	case 'd':
	{
	long a=0,b=0,c=0;
	getMinMax(i,a,b,c);
	setInt(i,c);
	}
	break;
	default: if (!numericonly) set(i,"");
	}
}

void ParamInterface::setMin(int i)
{
const char *t=type(i);
switch(*t)
	{
	case 'f':
	{
	double a=0,b=0,c=0;
	getMinMax(i,a,b,c);
	setDouble(i,a);
	}
	break;
	case 'd':
	{
	long a=0,b=0,c=0;
	getMinMax(i,a,b,c);
	setInt(i,a);
	}
	break;
	default: set(i,"");
	}
}

void ParamInterface::setMax(int i)
{
const char *t=type(i);
switch(*t)
	{
	case 'f':
	{
	double a=0,b=0,c=0;
	getMinMax(i,a,b,c);
	setDouble(i,b);
	}
	break;
	case 'd':
	{
	long a=0,b=0,c=0;
	getMinMax(i,a,b,c);
	setInt(i,b);
	}
	break;
	default: set(i,"");
	}
}

SString ParamInterface::getStringById(const char*prop)
{int i=findId(prop); if (i>=0) return getString(i); else return SString();}
long ParamInterface::getIntById(const char*prop)
{int i=findId(prop); if (i>=0) return getInt(i); else return 0;}
double ParamInterface::getDoubleById(const char*prop)
{int i=findId(prop); if (i>=0) return getDouble(i); else return 0;}
ExtObject ParamInterface::getObjectById(const char*prop)
{int i=findId(prop); if (i>=0) return getObject(i); else return ExtObject();}
ExtValue ParamInterface::getExtValueById(const char*prop)
{int i=findId(prop); if (i>=0) return getExtValue(i); else return ExtValue();}

int ParamInterface::setIntById(const char* prop,long v)
{int i=findId(prop); if (i>=0) return setInt(i,v); else return PSET_NOPROPERTY;}
int ParamInterface::setDoubleById(const char* prop,double v)
{int i=findId(prop); if (i>=0) return setDouble(i,v); else return PSET_NOPROPERTY;}
int ParamInterface::setStringById(const char* prop,const SString &v)
{int i=findId(prop); if (i>=0) return setString(i,v); else return PSET_NOPROPERTY;}
int ParamInterface::setObjectById(const char* prop,const ExtObject &v)
{int i=findId(prop); if (i>=0) return setObject(i,v); else return PSET_NOPROPERTY;}
int ParamInterface::setExtValueById(const char* prop,const ExtValue &v)
{int i=findId(prop); if (i>=0) return setExtValue(i,v); else return PSET_NOPROPERTY;}

int ParamInterface::save(VirtFILE* f,const SString* altname,bool force)
{
const char *p;
SString ws;
int err=0,i;
bool withname=false;
if ((!altname)||(altname->len()))
	{
	err|=(fputs(altname?((const char*)(*altname)):getName(),f)==EOF);
	err|=(fputs(":\n",f)==EOF);
	withname=true;
	}
for (i=0;p=id(i);i++)
	err|=saveprop(f,i,p,force);
if (withname)
	err|=(fputs("\n",f)==EOF);
return err;
}

int ParamInterface::saveprop(VirtFILE* f,int i,const char* p,bool force)
{
if ((flags(i)&PARAM_DONTSAVE)&&(!force)) return 0;
const char *typ=type(i);
if ((*typ=='p')||(*typ=='o')) return 0;

const char *t,*w;
SString ws;
int err=0,cr;

err|=(fputs(p,f)==EOF); fputc(':',f);
cr=0;
ws=get(i);
quoteTilde(ws);
w=ws;
if (ws.len()>50) cr=1;
else for (t=w;*t;t++) if ((*t==10)||(*t==13)) {cr=1; break;}
if (cr) fputs("~\n",f);
err|=(fputs(w,f)==EOF);
err|=(fputs(cr ? "~\n" : "\n",f)==EOF);
return err;
}


int SimpleAbstractParam::isequal(int i,void* defdata)
{ // defdata->member == object->member ?
void *backup=object;
switch(type(i)[0])
	{
	case 'd':
		{
		select(defdata);
		long x=getInt(i);
		select(backup);
		return x==getInt(i);
		}
	case 'f':
		{
		select(defdata);
		double x=getDouble(i);
		select(backup);
		return x==getDouble(i);
		}
	case 's':
		{
		select(defdata);
		SString x=getString(i);
		select(backup);
		return x==getString(i);
		}
	}
return 1;
}

void SimpleAbstractParam::save2(SString& f,void *defdata,int addcr)
{ // defdata!=NULL -> nie zapisuje wartosci domyslnych
const char *p;
int i;
int needlabel=0;
int first=1;
SString val;
SString t;
int fl;
// t+=SString(getName()); t+=':';
for (i=0;p=id(i);i++)
	if (!((fl=flags(i))&PARAM_DONTSAVE))
	{
	if (defdata && isequal(i,defdata))
		needlabel=1;
	else
		{
		if (!first) t+=", ";
#ifndef SAVE_ALL_NAMES
#ifdef SAVE_SELECTED_NAMES
		if (needlabel || !(fl & PARAM_CANOMITNAME))
#else
		if (needlabel)
#endif
#endif
			{ t+=p; t+="="; needlabel=0; }
		if (type(i)[0]=='s')
			{ // string - special case
			SString str=getString(i);
			if (strContainsOneOf(str,", \\\n\r\t"))
				{
				t+="\"";
				sstringQuote(str);
				t+=str;
				t+="\"";
				}
			else
				t+=str;
			}
		else
	   		t+=get(i);
		first=0;
		}
	}
if (addcr)
	t+="\n";
f+=t;
}

void ParamInterface::load(VirtFILE* f)
{
char t[100];
int i;
const char *p,*p0;
int p_len;
bool eol,loaded;
int ret;
while(fgets0(t,100,f,eol))
	{
	p0=t; while ((*p0==' ')||(*p0=='\t')) p0++;
	if (!*p0) break;
	p=strchr(p0,':'); if (!p) continue;
	p_len=p-p0;
	loaded=false;
	if (p_len&&((i=findIdn(p0,p_len))>=0)&&(!(flags(i)&PARAM_DONTLOAD)))
		{
		if (p0[p_len+1]=='~')
			{
			SString s;
			czytdotyldy(f,s);
			int ch; while((ch=fgetc(f))!=EOF) if (ch=='\n') break;
			unquoteTilde(s);
			ret=set(i,(const char*)s);
			}
		else
			{
			if (eol)
				ret=set(i,p0+p_len+1);
			else
				{
				SString tmp=p0+p_len+1;
				while(!eol)
					{
					if (!fgets0(t,100,f,eol)) break;
					tmp+=t;
					}
				ret=set(i,(const char*)tmp);
				}
			}
		if (ret & (PSET_HITMIN | PSET_HITMAX))
			FMprintf("Param","load2",FMLV_WARN,"Adjusted '%s' in '%s' (was too %s)",
				 id(i),getName(),(ret&PSET_HITMAX)?"big":"small");
		loaded=true;
		}
	if ((!loaded) && (p0[p_len+1]=='~'))
		{ // eat unrecognized multiline field
		SString s;
		czytdotyldy(f,s);
		int ch; while((ch=fgetc(f))!=EOF) if (ch=='\n') break;
		}
	}
}


/*
SString SimpleAbstractParam::getString(int i)
{
char *t;
switch (*(t=type(i)))
	{
	case 'd':
	{
	for (i=atol(get(i));i>=0;i--) if (t) t=strchr(t+1,'~');
	if (t)
		{
		t++;
		char *t2=strchr(t,'~');
		if (!t2) t2=t+strlen(t);
		SString str;
		strncpy(str.directWrite(t2-t),t,t2-t);
		str.endWrite(t2-t);
		return str;
		}
	}
	}
return get(i);
}
*/

int ParamInterface::findId(const char* n)
{
int i; const char *p;
	for (i=0;p=id(i);i++) if (!strcmp(n,p)) return i;
return -1;
}

int ParamInterface::findIdn(const char* naz,int n)
{
int i; const char *p;
	for (i=0;p=id(i);i++) if ((!strncmp(naz,p,n))&&(!p[n])) return i;
return -1;
}

void ParamInterface::get(int i,ExtValue &ret)
{
switch(type(i)[0])
	{
	case 'd':	ret.setInt(getInt(i)); break;
	case 'f':	ret.setDouble(getDouble(i)); break;
	case 's':	ret.setString(getString(i)); break;
	case 'o':	ret.setObject(getObject(i)); break;
	case 'x':	ret=getExtValue(i); break;
	default: FMprintf("ParamInterface","get",FMLV_ERROR,"'%s.%s' is not a field",getName(),id(i));
	}
}

int ParamInterface::set(int i,const ExtValue &v)
{
switch(type(i)[0])
	{
	case 'd': return setInt(i,v.getInt());
	case 'f': return setDouble(i,v.getDouble());
	case 's': { SString t=v.getString(); return setString(i,t); }
	case 'o': return setObject(i,v.getObject());
	case 'x': return setExtValue(i,v);
	default: FMprintf("ParamInterface","get",FMLV_ERROR,"'%s.%s' is not a field",getName(),id(i));
	}
return 0;
}

int ParamInterface::set(int i,const char *v)
{
switch(type(i)[0])
	{
	case 'd': return setInt(i,atol(v));
	case 'f': return setDouble(i,atof(v));
	case 's': { SString t(v); return setString(i,t); }
	case 'x':
	{
	ExtValue e;
	if (isdigit(*v)||((*v=='-')&&isdigit(v[1])))
		{
		if (strchr(v,'.')) e.setDouble(atof(v));
		else e.setInt(atol(v));
		}
	else
		{
		e.setString(SString(v));
		}
	return setExtValue(i,e);
	}
	}
return 0;
}

SString ParamInterface::getText(int i)
{
const char *t;
if ((*(t=type(i)))=='d')
	{
	for (int j=getInt(i);j>=0;j--) if (t) t=strchr(t+1,'~');
	if (t)
		{
		t++;
		const char *t2=strchr(t,'~');
		if (!t2) t2=t+strlen(t);
		return SString(t,t2-t);
		}
	}
return get(i);
}

SString ParamInterface::get(int i)
{
switch(type(i)[0])
	{
	case 'd':
		{
		SString tmp;
		sprintf(tmp.directWrite(20),"%ld",getInt(i)); tmp.endWrite();
		return tmp;
		}
	case 'f':
		{
		SString tmp;
		sprintf(tmp.directWrite(20),"%lg",getDouble(i)); tmp.endWrite();
		return tmp;
		}
	case 's':
		return getString(i);
	}
ExtValue v;
get(i,v);
return v.getString();
}


//////////////////////////////// PARAM ////////////////////////////////////

void *SimpleAbstractParam::getTarget(int i)
{
return (void*)(((char*)object)+entry(i)->offset);
//return &(object->*(entry(i)->fldptr));
}

///////// get

long SimpleAbstractParam::getInt(int i)
{
static ExtValue v;
ParamEntry *pe=entry(i);
if (pe->fun1)
	{
	(*(void(*)(void*,ExtValue*))pe->fun1)(object,&v);
	return v.getInt();
	}
else
	{
	void *target=getTarget(i);
	return *((long*)target);
	}
}

double SimpleAbstractParam::getDouble(int i)
{
static ExtValue v;
ParamEntry *pe=entry(i);
if (pe->fun1)
	{
	(*(void(*)(void*,ExtValue*))pe->fun1)(object,&v);
	return v.getDouble();
	}
else
	{
	void *target=getTarget(i);
	return *((double*)target);
	}
}

SString SimpleAbstractParam::getString(int i)
{
static ExtValue v;
ParamEntry *pe=entry(i);
if (pe->fun1)
	{
	(*(void(*)(void*,ExtValue*))pe->fun1)(object,&v);
	return v.getString();
	}
else
	{
	void *target=getTarget(i);
	return *((SString*)target);
	}
}

ExtObject SimpleAbstractParam::getObject(int i)
{
static ExtValue v;
ParamEntry *pe=entry(i);
if (pe->fun1)
	{
	(*(void(*)(void*,ExtValue*))pe->fun1)(object,&v);
	return v.getObject();
	}
else
	{
	void *target=getTarget(i);
	return *((ExtObject*)target);
	}
}

ExtValue SimpleAbstractParam::getExtValue(int i)
{
static ExtValue v;
ParamEntry *pe=entry(i);
if (pe->fun1)
	{
	(*(void(*)(void*,ExtValue*))pe->fun1)(object,&v);
	return v;
	}
else
	{
	void *target=getTarget(i);
	return *((ExtValue*)target);
	}
}


//////// set

int SimpleAbstractParam::setInt(int i,long x)
{
static ExtValue v;
ParamEntry *pe=entry(i);
if (pe->flags&PARAM_READONLY) return PSET_RONLY;
long a=0,b=0,result=0;
const char* t=pe->type+1;
while(*t) if (*t==' ') break; else t++;
if (sscanf(t,"%ld %ld",&a,&b)==2)
	if (a<=b) // jezeli max<min to znaczy ze min/max nie obowiazuje
		{
		if (x<a) {x=a; result=PSET_HITMIN;}
		else if (x>b) {x=b; result=PSET_HITMAX;}
		}

if (pe->fun2)
	{
	v.setInt(x);
	return result | (*(int(*)(void*,const ExtValue*))pe->fun2)(object,&v);
	}
else
	{
	void *target=getTarget(i);
	if (dontcheckchanges || (*((long*)target)!=x))
			{
			result |= PSET_CHANGED;
			*((long*)target)=x;
			}
	return result;
	}
}

int SimpleAbstractParam::setDouble(int i,double x)
{
static ExtValue v;
ParamEntry *pe=entry(i);
if (pe->flags&PARAM_READONLY) return PSET_RONLY;
double a=0,b=0; int result=0;
const char* t=pe->type+1;
while(*t) if (*t==' ') break; else t++;
if (sscanf(t,"%lg %lg",&a,&b)==2)
	if (a<=b) // jezeli max<min to znaczy ze min/max nie obowiazuje
		{
		if (x<a) {x=a; result=PSET_HITMIN;}
		else if (x>b) {x=b; result=PSET_HITMAX;}
		}

if (pe->fun2)
	{
	v.setDouble(x);
	return result | (*(int(*)(void*,const ExtValue*))pe->fun2)(object,&v);
	}
else
	{
	void *target=getTarget(i);
	if (dontcheckchanges || (*((double*)target)!=x))
		{
		result|=PSET_CHANGED;
		*((double*)target)=x;
		}
	return result;
	}
}

int SimpleAbstractParam::setString(int i,const SString& x)
{
static ExtValue v;
static SString vs;
const SString *xx=&x;
ParamEntry *pe=entry(i);
if (pe->flags&PARAM_READONLY) return PSET_RONLY;
const char* t=pe->type+1;
while(*t) if (*t==' ') break; else t++;
long a=0,b=0,result=0;
if (sscanf(t,"%ld %ld",&a,&b)==2)
	{
	if ((x.len()>b)&&(b>0))
		{
		vs=x.substr(0,b);
		xx=&vs;
		result|=PSET_HITMAX;
		}
	}

if (pe->fun2)
	{
	v.setString(*xx);
	return result | (*(int(*)(void*,const ExtValue*))pe->fun2)(object,&v);
	}
else
	{
	void *target=getTarget(i);
	if (dontcheckchanges || (!(*((SString*)target) == *xx)))
		{
		result|=PSET_CHANGED;
		*((SString*)target)=x;
		}
	return result;
	}
}

int SimpleAbstractParam::setObject(int i,const ExtObject& x)
{
static ExtValue v;
ParamEntry *pe=entry(i);
if (pe->flags&PARAM_READONLY) return PSET_RONLY;
if (pe->fun2)
	{
	v.setObject(x);
	return (*(int(*)(void*,const ExtValue*))pe->fun2)(object,&v);
	}
else
	{
	void *target=getTarget(i);
	*((ExtObject*)target)=x;
	return PSET_CHANGED;
	}
}

int SimpleAbstractParam::setExtValue(int i,const ExtValue& x)
{
ParamEntry *pe=entry(i);
if (pe->flags&PARAM_READONLY) return PSET_RONLY;
if (pe->fun2)
	{
	return (*(int(*)(void*,const ExtValue*))pe->fun2)(object,&x);
	}
else
	{
	void *target=getTarget(i);
	*((ExtValue*)target)=x;
	return PSET_CHANGED;
	}
}

void SimpleAbstractParam::call(int i,ExtValue *args,ExtValue *ret)
{
ParamEntry *pe=entry(i);
if (!pe) return;
if (pe->fun1 && (pe->type[0]=='p'))
	(*(void(*)(void*,ExtValue*,ExtValue*))pe->fun1)(object,args,ret);
else
	{
	FMprintf("SimpleAbstractParam","call",FMLV_ERROR,
		 (*pe->type!='p')?"'%s.%s' is not a function":"internal error - undefined function pointer for '%s.%s'",getName(),pe->id);
	}
}

void SimpleAbstractParam::setDefault(bool numericonly)
{
bool save=dontcheckchanges;
dontcheckchanges=1;
ParamInterface::setDefault(numericonly);
dontcheckchanges=save;
}

void SimpleAbstractParam::setDefault(int i,bool numericonly)
{
bool save=dontcheckchanges;
dontcheckchanges=1;
ParamInterface::setDefault(i,numericonly);
dontcheckchanges=save;
}

// zwraca adres poczatku linii
// len = dlugosc linii (bez \n)
// 0 moze oznaczac linie dlugosci 0 lub koniec SStringa
// poz jest przesuwane na poczatek nastepnej linii
// typowa petla: for(poz=0;poz<s.d;) {line=getline(s,poz,len);...
static const char *getline(const SString &s,int &poz,int &len)
{
const char *beg=(const char*)s+poz;
if (poz>=s.len()) {poz=s.len(); len=0; return (const char*)s+s.len();}
const char *lf=strchr(beg,'\n');
if (!lf) { lf=(const char*)s+s.len()-1; poz=s.len(); }
else {poz=(lf-(const char*)s)+1; if (poz>s.len()) poz=s.len();}
while (lf>=beg) if ((*lf=='\n')||(*lf=='\r')) lf--; else break;
len=lf-beg+1;
return beg;
}

void ParamInterface::load2(const SString &s,int &poz)
{
int i; // numer akt. parametru
int tmpi;
int len;
int ret;
const char *t,*lin,*end;
const char *rownasie,*przecinek;
char remember;
const char *quote,*quote2;
const char *value,*valstop;
SString tmpvalue;
if (poz>=s.len()) return;
t=(const char*)s+poz;

// na razie wszystko musi byc w jednej linii...
lin=getline(s,poz,len);
if (!len) return; // pusta linia = koniec
i=0;
end=lin+len;
while(t<end)
{
// przetwarzanie jednego par
while (strchr(" \n\r\t",*t)) if (t<end) t++; else return;

przecinek=strchrlimit(t,',',end); if (!przecinek) przecinek=end;
quote=strchrlimit(t,'\"',przecinek);
if (quote)
	{
	quote2=skipQuoteString(quote+1,end);
	if (quote2>przecinek)
		{
		przecinek=strchrlimit(quote2+1,',',end);
		if (!przecinek) przecinek=end;
		}
	rownasie=strchrlimit(t,'=',quote);
	}
else
	{
	rownasie=strchrlimit(t,'=',przecinek);
	quote2=0;
	}
if (rownasie==t) { t++; rownasie=0; }
if (przecinek==t)	// skip empty value
	{
	t++; i++;
	continue;
	}
if (rownasie) // have parameter name
	{
	tmpi=findIdn(t,rownasie-t);
	i=tmpi;
	if (tmpi<0)
		FMprintf("Param","load2",FMLV_WARN,"Unknown property name for '%s' (ignored)",getName());
	t=rownasie+1; // t=value
	}
#ifdef WARN_MISSING_NAME
else
#ifdef SAVE_SELECTED_NAMES
if (!(flags(i)&PARAM_CANOMITNAME))
#endif
	{
	FMprintf("Param","load2",FMLV_WARN,"Missing property name in '%s' (assuming '%s')",
		 getName(),id(i)?id(i):"unknown property?");
	}
#endif
if ((i>=0)&&id(i))
	{
	value=t;
	if (quote)
		{
		tmpvalue.copyFrom(quote+1,quote2-quote-1);
		sstringUnquote(tmpvalue);
		value=tmpvalue;
		valstop=quote2;
		}
	else
		if (przecinek<end) valstop=przecinek; else valstop=end;

	remember=*valstop;
	*(char*)valstop=0;
	ret=set(i,value);
	if (ret&(PSET_HITMAX|PSET_HITMIN))
		FMprintf("Param","load2",FMLV_WARN,"Adjusted '%s' in '%s' (was too %s)",
			id(i),getName(),(ret&PSET_HITMAX)?"big":"small");
	*(char*)valstop=remember;
	}

if (i>=0) i++;
#ifdef __CODEGUARD__ 
if (przecinek<end-1) t=przecinek+1; else return;
#else
t=przecinek+1;
#endif
}
return;
}

int Param::grmember(int g,int a)
{
if ((getGroupCount()<2)&&(!g))
	return (a<getPropCount())?a:-9999;

ParamEntry *e=entry(0);
int x=0,i=0;
for (;e->id;i++,e++)
	{
	if (e->group==g) 
		if (a==x) return i; else x++;
	}
return -9999;
}
