// This file is a part of Framsticks GDK library.
// Copyright (C) 2002-2006  Szymon Ulatowski.  See LICENSE.txt for details.
// Refer to http://www.frams.alife.pl/ for further information.

#include "geno.h"
#include "stdiofile.h"
#include "sstringutils.h"
#include "defgenoconv.h"
#include "neuroimpl.h"
#include "neurofactory.h"
#include "stdouterr.h"

/**
 @file
 Sample code: Neural network tester (can run your custom neurons)
*/

StdoutErrorHandler err; //redirect model-related errors to stdout
DefaultGenoConvManager gcm; //without this object the application would only handle "format 0" genotypes

#ifndef NOCREATUREOBJECT
#include "creatmechobj.h"
int CreatMechObject::modeltags_id=0;
int CreatMechObject::mechtags_id=0;
#endif

ParamEntry creature_paramtab[]={0};

#ifdef VEYETEST
#include "neuroimpl-vectoreye.h"

#define N_VEye 0
#define N_VMotor 1
#define N_Mode 2
#define N_Fitness 3
#define LEARNINGSTEPS 50

void veyeStep(Model &m,int step)
{
  static float angle=0;

  NeuroNetImpl::getImpl(m.getNeuro(N_Mode))->setState(step>=LEARNINGSTEPS); //0 (learning) or 1 (normal)

	NeuroImpl *ni=NeuroNetImpl::getImpl(m.getNeuro(N_VEye));
  ((NI_VectorEye*)ni)->relpos.y=0;
  ((NI_VectorEye*)ni)->relpos.z=0;
  if (NeuroNetImpl::getImpl(m.getNeuro(N_Mode))->getNewState()<0.5)
  { //learning
    ((NI_VectorEye*)ni)->relpos.x=5.0*sin(2*M_PI*step/LEARNINGSTEPS);
  }
  else
  { //VMotor controls location of VEye
    angle+=NeuroNetImpl::getImpl(m.getNeuro(N_VMotor))->getState();
    angle=fmod((double)angle,M_PI*2.0);
    ((NI_VectorEye*)ni)->relpos.x=5*sin(angle);
  }

  NeuroNetImpl::getImpl(m.getNeuro(N_Fitness))->setState(angle); //wymaga poprawy
  //oraz trzeba przemyslec kolejnosc get/set'ow neuronow zeby sygnal sie dobrze propagowal.
}
#endif

int main(int argc,char*argv[])
{
if (argc<=1)
	{
	puts("no genotype");
	return 10;
	}
SString gen(argv[1]);
if (!strcmp(gen,"-"))
	{
	gen=0;
	StdioFILEDontClose in(stdin);
	loadSString(&in,gen);
	}
Geno g(gen);
if (!g.isValid()) {puts("invalid genotype");return 5;}
Model m(g);
if (!m.getNeuroCount()) {puts("no neural network");return 1;}
printf("%d neurons,",m.getNeuroCount());
NeuroFactory::setImplementation();
NeuroNetImpl *nn=new NeuroNetImpl(m);
int i; Neuro *n;
if (!nn->getErrorCount()) printf(" no errors\n");
else
	{
	printf(" %d errors:",nn->getErrorCount());
	int no_impl=0; SString no_impl_names;
	int init_err=0; SString init_err_names;
	for(i=0;i<m.getNeuroCount();i++)
		{
		n=m.getNeuro(i);
		NeuroImpl *ni=NeuroNetImpl::getImpl(n);
		if (!ni)
			{
			if (no_impl) no_impl_names+=',';
			sprintf(no_impl_names.directAppend(100),"#%d.%s",
				i,(const char*)n->getClassName());
			no_impl_names.endAppend();
			no_impl++;
			}
		else if (ni->status==NeuroImpl::InitError)
			{
			if (init_err) init_err_names+=',';
			sprintf(init_err_names.directAppend(100),"#%d.%s",
				i,(const char*)n->getClassName());
			init_err_names.endAppend();
			init_err++;
			}
		}
	printf("\n");
	if (no_impl) printf("%d x missing implementation (%s)\n",no_impl,(const char*)no_impl_names);
	if (init_err) printf("%d x failed initialization (%s)\n",init_err,(const char*)init_err_names);
	}
int steps=1;
if (argc>2) steps=atol(argv[2]);
int st;
printf("step");
for(i=0;i<m.getNeuroCount();i++)
	{
	n=m.getNeuro(i);
	printf("\t#%d.%s",i,(const char*)n->getClassName());
	}
printf("\n");
for(st=0;st<=steps;st++)
	{
#ifdef VEYETEST
  veyeStep(m,st);
#endif
	printf("%d",st);
	for(i=0;i<m.getNeuroCount();i++)
		{
		n=m.getNeuro(i);
		printf("\t%g",n->state);
		}
	printf("\n");
	nn->simulateNeuroNet();
	}
NeuroFactory::freeImplementation();
}
