// This file is a part of Framsticks GDK library.
// Copyright (C) 2002-2006  Szymon Ulatowski.  See LICENSE.txt for details.
// Refer to http://www.frams.alife.pl/ for further information.

#ifndef _NEUROFACTORY_H_
#define _NEUROFACTORY_H_

#include "modelparts.h"

class NeuroImpl;

class NeuroFactory
{
public:
static NeuroImpl* setImplementation(NeuroClass *nc,NeuroImpl *ni,bool deleteold=1);
static NeuroImpl* setImplementation(const SString& classname,NeuroImpl *ni,bool deleteold=1);
static class NeuroImpl* createNeuroImpl(Neuro *n)
	{NeuroClass *nc=n->getClass(); if (!nc) return 0; return createNeuroImpl(nc);}
static class NeuroImpl* createNeuroImpl(NeuroClass *nc);

static int used;
static void setImplementation();
static void freeImplementation();
};

#endif
