// This file is a part of Framsticks GDK library.
// Copyright (C) 2002-2006  Szymon Ulatowski.  See LICENSE.txt for details.
// Refer to http://www.frams.alife.pl/ for further information.

#include "neurofactory.h"
#include "sstring.h"
#include "param.h"
#include "neuroimpl.h"
#include "neuroimplfiles.h"

int NeuroFactory::used=0;

NeuroImpl* NeuroFactory::createNeuroImpl(NeuroClass *nc)
{
if (!nc) return 0;
if (!nc->active) return 0;
NeuroImpl* ni=(NeuroImpl*)nc->impl;
if (!ni) return 0;
return ni->makeNew();
}

NeuroImpl* NeuroFactory::setImplementation(const SString& classname,NeuroImpl *ni,bool deleteold)
{
NeuroClass *nc=Neuro::getClass(classname);
if (!nc) return ni;
return setImplementation(nc,ni,deleteold);
}

NeuroImpl* NeuroFactory::setImplementation(NeuroClass *nc,NeuroImpl *ni,bool deleteold)
{
NeuroImpl* old_ni=(NeuroImpl*)nc->impl;
nc->impl=ni;
if (deleteold && old_ni) delete old_ni;
return old_ni;
}

#include "neuroimplfiles.h"
#include "neurocls-factory.h"

void NeuroFactory::setImplementation()
{
if (!used)
	{
	SETIMPLEMENTATION
	}
used++;
}

void NeuroFactory::freeImplementation()
{
used--;
if (!used)
	{
	for(int i=0;i<Neuro::getClassCount();i++)
		setImplementation(Neuro::getClass(i),0);
	}
}

