// This file is a part of Framsticks GDK library.
// Copyright (C) 2002-2006  Szymon Ulatowski.  See LICENSE.txt for details.
// Refer to http://www.frams.alife.pl/ for further information.

#include "genotypeloader.h"

/**
 @file
 Sample code: Loading genotypes from Framsticks files

 \include loadertest.cpp
*/

int main(int argc,char*argv[])
{
puts("This example shows how to load genotypes from the standard Framsticks genotype file");
if (argc<2)
	{
	puts("(Please give the file name as command line argument)");
	return 1;
	}

long count=0,totalsize=0;
MiniGenotypeLoader loader(argv[1]);
// using char* constructor (passing the file name to open)
MiniGenotype *loaded;
while(loaded=loader.loadNextGenotype())
	{ // if loaded != NULL then the "org:" object data was
	 // loaded into MiniGenotype object
	count++;
	totalsize+=loaded->genotype.len();
	printf("%d. %s\t(%d characters)\n",count,(const char*)loaded->name,loaded->genotype.len());
	}
// the loop repeats until loaded==NULL, which could be beacause of error
if (loader.getStatus()==MiniGenotypeLoader::OnError)
	printf("Error: %s",(const char*)loader.getError());
// (otherwise it was the end of the file)

printf("\ntotal: %d items, %d characters\n",count,totalsize);
return 0;
}
