// This file is a part of Framsticks GDK library.
// Copyright (C) 2002-2006  Szymon Ulatowski.  See LICENSE.txt for details.
// Refer to http://www.frams.alife.pl/ for further information.

#ifndef _GENO_H_
#define _GENO_H_

#include "sstring.h"
#include "extvalue.h"

class MultiMap;

/// basic information about a single genotype.
class Geno: public DestrBase
{
SString gen;
SString name;
char format;
SString txt;
int isvalid; ///< <0 -> unknown   >=0 -> value for "isValid"

Geno *f0gen;

int mapinshift; /// # of characters in the initial comment
int mapoutshift; /// # of characters in the output comment
int multiline;

void init(const SString& genstring,int genformat,const SString& genname,const SString& comment);
void validate(void);

void freeF0();

int isInvalid() {return isvalid==0;}

friend class Model;
friend class GenoConvManager;
	
public:
/// create a genotype object from primitives
/// @param genstring pure genotype, without any comments
/// @param genformat genotype format
/// @param comment information about genotype (for genetic operators and "history")
Geno(const char *genstring=0,int genformat=-1,const char *genname=0,const char *comment=0);

/// create a genotype object from primitives
/// @param genstring pure genotype, wihtout any comments
/// @param genformat genotype format
/// @param name genotype name, new name will generated if needed
/// @param comment information about genotype (for genetic operators and "history")
Geno(const SString& genstring,int genformat,const SString& genname,const SString& comment);

/// create object from full string, containing optional format and comment information
Geno(const SString & fullstring);

/// clone
Geno(const Geno& src);

void operator=(const Geno& src);

~Geno();

void setValid(int v) {isvalid=v;}
int getValid() {return isvalid;}

/// return string representation, with format comment at the beginning
SString toString(void);
SString shortString(void);

void setString(const SString& genewithcomments);

/** @param newformat=-1 -> don't change */
void setGene(const SString& g, int newformat=-1);
SString getGene(void) const;

SString getName(void) const;
void setName(const SString&);
int getFormat(void) const;

SString getComment(void) const;
void setComment(const SString&);

/// invalid genotype cannot be used to build a creature
int isValid(void);

/// make converted version of the genotype.
Geno getConverted(int otherformat,MultiMap *m=0);

/// @return -1 = before first char in the string
/// @return -2 = after last char in the string
int mapGenToString(int genpos) const;
/// @return -1 = before first char in the genotype
/// @return -2 = after last char in the genotype
int mapStringToGen(int stringpos) const;

int operator==(const Geno &g) {return (format==g.format)&&(gen==g.gen);}

void* owner;
};

#ifndef NO_GENOCONVMANAGER
#include "genoconv.h"
#endif

#endif
