// This file is a part of Framsticks GDK library.
// Copyright (C) 2002-2006  Szymon Ulatowski.  See LICENSE.txt for details.
// Refer to http://www.frams.alife.pl/ for further information.

#ifndef _FRAMSG_H_
#define _FRAMSG_H_

#include <stdarg.h>

void FMprintf(const char *o,const char *m,int w,const char *bl, ...);
void FMprintf(const char *o,const char *m,int w,const char *bl,va_list va);
void FramMessage(const char *o,const char *m,const char *bl,int w);

#define FMLV_DEBUG -1
#define FMLV_INFO 0
#define FMLV_WARN 1
#define FMLV_ERROR 2
#define FMLV_CRITICAL 3

/*
w: weight (importance) of a message
-1:debugging information, not needed for final users
0: information
1: warning or corrected error
2: uncorrected error. can cause malfunction
3: serious error, causes side effects. user should save what can be
   saved and restart the application
*/

#endif
