// This file is a part of Framsticks GDK library.
// Copyright (C) 2002-2006  Szymon Ulatowski.  See LICENSE.txt for details.
// Refer to http://www.frams.alife.pl/ for further information.

#ifndef _ERRMANAGER_H_
#define _ERRMANAGER_H_

#include "list.h"
#include "sstring.h"
#include "framsg.h"

class ErrorHandlerBase;

class ErrorManager
{
friend class ErrorHandlerBase;
SListTempl<ErrorHandlerBase*> handlers;
void send(int level,const char *o,const char *m,const char *bl,int w);
  public:
int find(ErrorHandlerBase *r) {return handlers.find(r);}
int add(ErrorHandlerBase *r);
void remove(int i);
void remove(ErrorHandlerBase *r);
void removeAll();
void send(const char *o,const char *m,const char *bl,int w)
	{send(handlers.size()-1,o,m,bl,w);}
~ErrorManager() {removeAll();}
};

extern ErrorManager globalErrorManager;

////////////////////////////////////////

class ErrorHandlerBase
{
friend class ErrorManager;
  protected:
ErrorManager* mgr;
int options;

  public:

enum HandlerOptions
 { DontBlock=1, CannotBeBlocked=2, DontEnable=4 };

void FMprintf(const char *o,const char *m,int w,const char *bl, ...);
void send(const char *o,const char *m,const char *bl,int w);

bool isEnabled() {return mgr?1:0;}
void enable();
void disable();

ErrorHandlerBase(int opts=0):options(opts),mgr(0)
	{if (!(options&DontEnable)) enable();}
~ErrorHandlerBase()
	{disable();}

virtual void handle(const char *o,const char *m,const char *bl,int w) {}
};

///////////////////////////////////////////

class ErrorHandler: public ErrorHandlerBase
{
  protected:
int maxlevel,errcount,warncount,storlevel,storcount;
SString msgs;

  public:

void reset() {maxlevel=FMLV_INFO-1; errcount=warncount=storcount=0; msgs=0;}

enum Options2
 { StoreFirstMessage=8, StoreAllMessages=16 };

int getErrorCount()       {return errcount;}
int getWarningCount()     {return warncount;}
int getStoredCount()      {return storcount;}
int getErrorLevel()       {return maxlevel;}
const SString& getMessages() {return msgs;}

ErrorHandler(int opts=0,int store=FMLV_ERROR):ErrorHandlerBase(opts),storlevel(store)
	{reset();}

void handle(const char *o,const char *m,const char *bl,int w);
};

#endif

