// This file is a part of Framsticks GDK library.
// Copyright (C) 2002-2006  Szymon Ulatowski.  See LICENSE.txt for details.
// Refer to http://www.frams.alife.pl/ for further information.

#include "defgenoconv.h"

#include "gen-config.h"

#ifdef USE_GENCONV_F10
#include "conv_f1.h"
#endif
#ifdef USE_GENCONV_F20
#include "conv_f2.h"
#endif
#ifdef USE_GENCONV_F32
#include "conv_f3.h"
#endif
#ifdef USE_GENCONV_F40
#include "conv_f4.h"
#endif
#ifdef USE_GENCONV_F41_TEST
#include "conv_f4.h"
#endif
#ifdef USE_GENCONV_F50
#include "conv_f5.h"
#endif
#ifdef USE_GENCONV_F60
#include "geno_f6.h"
#endif
#ifdef USE_GENCONV_F70
#include "conv_f7.h"
#endif
#ifdef USE_GENCONV_F81
#include "conv_f8.h"
#endif

DefaultGenoConvManager::DefaultGenoConvManager()
{
#ifdef USE_GENCONV_F10
addConverter(new GenoConv_F1());
#endif
#ifdef USE_GENCONV_F20
addConverter(new GenoConv_F20());
#endif
#ifdef USE_GENCONV_F32
addConverter(new GenoConv_F32());
#endif
#ifdef USE_GENCONV_F40
addConverter(new GenoConv_F40());
#endif
#ifdef USE_GENCONV_F41_TEST
addConverter(new GenoConv_F41_TestOnly());
#endif
#ifdef USE_GENCONV_F50
addConverter(new GenoConv_F50);
#endif
#ifdef USE_GENCONV_F60
addConverter(new GenoConv_F60);
#endif
#ifdef USE_GENCONV_F70
addConverter(new GenoConv_F70);
#endif
#ifdef USE_GENCONV_F81
addConverter(new GenoConv_F81);
#endif

param.updatetab();
}
