package com.framsticks.framclipse.internal.parser;

import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;

import com.framsticks.framclipse.editors.EditorType;


public class FramclipseParser {

	public final static void recursiveSetOffset(Node root,int begin,int end){
		final int modelNumChild = root.jjtGetNumChildren();
		for (int i = 0; i < modelNumChild; ++i) {
			final Node child = root.jjtGetChild(i);
			if (child instanceof ElementWithOffset) {
				final ElementWithOffset ewo = (ElementWithOffset) child;
				ewo.setBeginOffset(begin);
				ewo.setEndOffset(end);
			}
			recursiveSetOffset(child, begin, end);
		}
		
	}
	
	public Node parse(String content, EditorType editorType, URL url) throws ParseException {
		if (editorType.equals(EditorType.FRAMSCRIPT)) {

		} else {
			try {
				FramclipseNonScriptParser parser = new FramclipseNonScriptParser(
						content);
				ElementWithOffset model = parser.FramclipseFile();
				model.setBeginOffset(0);
				model.setEndOffset(content.length() - 1);
				if (url == null) return model;
				String path = url.toString();
				path = path.substring(0, path.lastIndexOf('/') + 1);
				// if (File.separatorChar != '/')
				// path = path.replace('/', File.separatorChar);

				final int modelNumChild = model.jjtGetNumChildren();
				for (int i = 0; i < modelNumChild; ++i) {
					final Node child = model.jjtGetChild(i);
					if (child instanceof ASTGlobalInclude) {
						final ASTGlobalInclude inc = (ASTGlobalInclude) child;
						final String fname = inc.getFileName();
						if (!"N/A".equals(fname)) {
							try {
								final URL incurl = new URL(path + fname);
								final InputStream stream = incurl.openStream();
								final CharStreamWithOffset cs = new CharStreamWithOffset(stream);
								final FramclipseNonScriptParser parser2 = new FramclipseNonScriptParser(
										cs);
								final Field fld = FramclipseNonScriptParser.class.getDeclaredField("charStream");
								fld.setAccessible(true);
								fld.set(parser2, cs);								
								final ASTFramclipseFile include = parser2
										.FramclipseFile();
								for (int j = 0; j < include.jjtGetNumChildren(); ++j) {
									final Node ic = include.jjtGetChild(j);
									inc.jjtAddChild(ic, j);
									ic.jjtSetParent(inc);
								} 
								recursiveSetOffset(inc, inc.getBeginOffset(), inc.getEndOffset());
							} catch (ParseException e) {
								inc.setValid(false); 
								System.err.println("In "+path+fname);
								e.printStackTrace();
							}
						}
					}
				}
				return model;
			} catch (ParseException e) {
				e.printStackTrace();
				throw e;
			} catch (TokenMgrError e) {
				e.printStackTrace();
				throw e;
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		return null;

	}
}
