package com.framsticks.framclipse.editors.configuration;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.ide.ResourceUtil;

import com.framsticks.framclipse.editors.FramclipseEditor;
import com.framsticks.framclipse.editors.folding.FramclipseFoldingAnnotation;
import com.framsticks.framclipse.internal.parser.ASTCodeSection;
import com.framsticks.framclipse.internal.parser.ASTFObject;
import com.framsticks.framclipse.internal.parser.ASTFunction;
import com.framsticks.framclipse.internal.parser.ASTGlobalInclude;
import com.framsticks.framclipse.internal.parser.ASTProperty;
import com.framsticks.framclipse.internal.parser.ElementWithOffset;
import com.framsticks.framclipse.internal.parser.FramclipseParser;
import com.framsticks.framclipse.internal.parser.Node;
import com.framsticks.framclipse.internal.parser.ParseException;
import com.framsticks.framclipse.internal.parser.TokenMgrError;


public class FramclipseReconcilingStrategy implements IReconcilingStrategy,
														IReconcilingStrategyExtension
{

	FramclipseEditor fEditor = null;
	private IDocument fDocument;
	private FramclipseParser parser = new FramclipseParser();
	
	protected final ArrayList<Position> fPositions = new ArrayList<Position>();
	
	public void reconcile(IRegion partition) {
		
		doAll();
	}

	public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
		doAll();
	}

	public void setDocument(IDocument document) {
		this.fDocument = document;
		
	}

	public FramclipseEditor getEditor() {
		return fEditor;
	}

	public void setEditor(FramclipseEditor editor) {
		fEditor = editor;
	}

	public void initialReconcile() {
		System.out.println("initial reconcile...");
		doAll();
	}

	public void setProgressMonitor(IProgressMonitor monitor) {
		
	}
	
	void doAll()
	{
		Display.getDefault().syncExec(new Runnable() {
			
			public void run() {
				Object adapter = fEditor.getAdapter(ITextOperationTarget.class);
				if(adapter instanceof TextViewer)
				{
					TextViewer viewer = (TextViewer)adapter;
					try
					{
						viewer.setRedraw(false);
						
						IResource resource = ResourceUtil.getResource(fEditor.getEditorInput());
						resource.deleteMarkers(IMarker.PROBLEM, true, IResource.DEPTH_ZERO);

						try {
							parseDocument();
						} catch (ParseException e) {
							ErrorHandler<ParseException> handler = new ErrorHandler.ParseErrorHandler();
							handler.createMarker(resource, e);
						} catch (TokenMgrError e) {
							ErrorHandler<TokenMgrError> handler = new ErrorHandler.TokenErrorHandler();
							handler.createMarker(resource, e);
						}
						fEditor.updateOutlinePage();
						
						collectAndUpdateAnnotations();
					} catch (CoreException e) {
						e.printStackTrace();
					}
					finally
					{
						viewer.setRedraw(true);
					}
				}
			}
			
		});
	
	}
	
	void parseDocument() throws ParseException
	{
		
		URL path = null;
		final IEditorInput ei = fEditor.getEditorInput();
		if (ei instanceof IPathEditorInput) {
			final IPathEditorInput pei = (IPathEditorInput) ei;
			final IPath p = pei.getPath().makeAbsolute();
			try {
				path = p.toFile().toURL();
			} catch (MalformedURLException e) {
				path= null;
			}
		}   
		if (ei instanceof IURIEditorInput) {
			final IURIEditorInput uei = (IURIEditorInput) ei;
			final URI uri = uei.getURI();
			try {
				path = uri.toURL();
			} catch (MalformedURLException e) {
				path = null;
			}			
		}
		Node model = parser.parse(fDocument.get(), fEditor.getEditorType(),path);
		fEditor.setFileModel(model);
	}
	
	void recursiveAddAnnotations(List<FramclipseFoldingAnnotation> annotations, Node element)
	{
		if (element instanceof ASTGlobalInclude)
			return;
		if(element instanceof ASTFObject ||
		   element instanceof ASTProperty || 
		   element instanceof ASTFunction ||
		   element instanceof ASTCodeSection)
		{
			try {
				ElementWithOffset ewo = (ElementWithOffset)element;
				/*if(ewo instanceof ASTFObject)
					System.out.println("adding for " + ((ASTFObject)ewo).getClassName());*/
				if(fDocument.getLineOfOffset(ewo.getBeginOffset()) != fDocument.getLineOfOffset(ewo.getEndOffset()))
				{
					annotations.add(new FramclipseFoldingAnnotation(ewo));
				}
				
			}
			catch(BadLocationException ex)
			{
				
			}
			
		}
		
		for(int k = 0; k < element.jjtGetNumChildren(); ++k)
			recursiveAddAnnotations(annotations, element.jjtGetChild(k));
	}
	
	void collectAndUpdateAnnotations()
	{
		Node model = fEditor.getFileModel();
		
		if(model != null)
		{
			List<FramclipseFoldingAnnotation> annots = new ArrayList<FramclipseFoldingAnnotation>();
			recursiveAddAnnotations(annots, model);
			
			//System.out.println("collected annotations: " + annots.size());
			
			fEditor.updateFoldingStructure(annots);	
		}
	}
	
	/**
	 * @deprecated
	 */
	void scanAll()
	{
		fPositions.clear();
		
		try
		{
			boolean tildeSectionStartFound = false;
			int tildeStartPos = 0;
			boolean plainSectionStartFound = false;
			int plainStartPos = 0;
			
			String lineSep = System.getProperty("line.separator");
			
			for(int k = 0; k < fDocument.getNumberOfLines(); ++k)
			{
				String line = fDocument.get(fDocument.getLineOffset(k), fDocument.getLineLength(k));
				
				if(line.matches(".*:( |\\t)*" + lineSep)){
					if(!tildeSectionStartFound)
					{
						plainSectionStartFound = true;
						plainStartPos = fDocument.getLineOffset(k);
					}
				}
				else if(line.matches(".*~( |\\t)*" + lineSep))
				{
					if(!tildeSectionStartFound)
					{
						tildeStartPos = fDocument.getLineOffset(k);
						tildeSectionStartFound = true;
					}
					else
					{
						fPositions.add(new Position(tildeStartPos, fDocument.getLineOffset(k) + fDocument.getLineLength(k) - tildeStartPos));
						tildeSectionStartFound = false;
					}
				}
				else if(line.matches("( |\\t)*" + lineSep))
				{
					if(plainSectionStartFound)
					{
						if(!tildeSectionStartFound)
						{
							plainSectionStartFound = false;
							fPositions.add(new Position(plainStartPos, fDocument.getLineOffset(k) - plainStartPos));
						}
					}
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	
	}

}
