package games.scenarios;

import games.BoardGame;
import games.GameMove;
import games.Player;

import java.util.List;

public class SimpleTwoPlayersGameScenario implements GameScenario {

	private Player[] players;

	public SimpleTwoPlayersGameScenario(Player[] players) {
		this.players = players;
	}

	public int play(BoardGame game) {
		while (!game.endOfGame()) {
			List<? extends GameMove> moves = game.findMoves();
			if (!moves.isEmpty()) {
				GameMove bestMove = null;
				double bestEval = Double.NEGATIVE_INFINITY;
				for (GameMove move : moves) {
					double eval = game.evalMove(players[game.getCurrentPlayer()], move);
					if (eval > bestEval) {
						bestEval = eval;
						bestMove = move;
					}
				}
				game.makeMove(bestMove);
			}
			game.switchPlayer();
		}
		return game.getOutcome();
	}
}
