package games.scenarios;

import ec.util.MersenneTwisterFast;
import games.BoardGame;
import games.GameMove;
import games.Player;

import java.util.List;

public class RandomizedTwoPlayersGameScenario implements GameScenario {

	private Player[] players;
	private double[] prob;
	private MersenneTwisterFast random;
	
	public RandomizedTwoPlayersGameScenario(MersenneTwisterFast random, Player[] players, double[] prob) {
		this.players = players;
		this.prob = prob;
		this.random = random;
	}
	
	public int play(BoardGame game) {
		while (!game.endOfGame()) {
			List<? extends GameMove> moves = game.findMoves();
			if (!moves.isEmpty()) {
				GameMove bestMove = null;
				if (random.nextBoolean(prob[game.getCurrentPlayer()])) {
					bestMove = moves.get(random.nextInt(moves.size()));
				} else {
					double bestEval = Double.NEGATIVE_INFINITY;
					for (GameMove move : moves) {
						double eval = game.evalMove(players[game.getCurrentPlayer()], move);
						if (eval > bestEval) {
							bestEval = eval;
							bestMove = move;
						}
					}
				}
				game.makeMove(bestMove);
			}
			game.switchPlayer();
		}
		return game.getOutcome();
	}
}
